/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Value;

public class ResetResponseHandler
implements ResponseHandler {
    private final Channel channel;
    private final ChannelPool pool;
    private final InboundMessageDispatcher messageDispatcher;
    private final Clock clock;
    private final CompletableFuture<Void> releaseFuture;

    public ResetResponseHandler(Channel channel, ChannelPool pool, InboundMessageDispatcher messageDispatcher, Clock clock, CompletableFuture<Void> releaseFuture) {
        this.channel = channel;
        this.pool = pool;
        this.messageDispatcher = messageDispatcher;
        this.clock = clock;
        this.releaseFuture = releaseFuture;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.releaseChannel();
    }

    @Override
    public void onFailure(Throwable error) {
        this.releaseChannel();
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private void releaseChannel() {
        this.messageDispatcher.unMuteAckFailure();
        ChannelAttributes.setLastUsedTimestamp(this.channel, this.clock.millis());
        Future<Void> released = this.pool.release(this.channel);
        released.addListener(ignore -> this.releaseFuture.complete(null));
    }
}

