/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.async.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.async.NettyConnection;
import org.neo4j.driver.internal.async.pool.ActiveChannelTracker;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelPool;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class ConnectionPoolImpl
implements ConnectionPool {
    private final ChannelConnector connector;
    private final Bootstrap bootstrap;
    private final ActiveChannelTracker activeChannelTracker;
    private final NettyChannelHealthChecker channelHealthChecker;
    private final PoolSettings settings;
    private final Clock clock;
    private final Logger log;
    private final ConcurrentMap<BoltServerAddress, ChannelPool> pools = new ConcurrentHashMap<BoltServerAddress, ChannelPool>();
    private final AtomicBoolean closed = new AtomicBoolean();

    public ConnectionPoolImpl(ChannelConnector connector, Bootstrap bootstrap, PoolSettings settings, Logging logging, Clock clock) {
        this.connector = connector;
        this.bootstrap = bootstrap;
        this.activeChannelTracker = new ActiveChannelTracker(logging);
        this.channelHealthChecker = new NettyChannelHealthChecker(settings, clock);
        this.settings = settings;
        this.clock = clock;
        this.log = logging.getLog(this.getClass().getSimpleName());
    }

    @Override
    public CompletionStage<Connection> acquire(BoltServerAddress address) {
        this.log.debug("Acquiring connection from pool for address: %s", address);
        this.assertNotClosed();
        ChannelPool pool = this.getOrCreatePool(address);
        Future<Channel> connectionFuture = pool.acquire();
        return Futures.asCompletionStage(connectionFuture).thenApply(channel -> {
            this.assertNotClosed(address, (Channel)channel, pool);
            return new NettyConnection((Channel)channel, pool, this.clock);
        });
    }

    @Override
    public void purge(BoltServerAddress address) {
        this.log.info("Purging connections for address: %s", address);
        this.activeChannelTracker.purge(address);
        ChannelPool pool = (ChannelPool)this.pools.remove(address);
        if (pool != null) {
            pool.close();
        }
    }

    @Override
    public boolean hasAddress(BoltServerAddress address) {
        return this.pools.containsKey(address);
    }

    @Override
    public int activeConnections(BoltServerAddress address) {
        return this.activeChannelTracker.activeChannelCount(address);
    }

    @Override
    public CompletionStage<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.info("Closing the connection pool", new Object[0]);
            try {
                for (ChannelPool pool : this.pools.values()) {
                    pool.close();
                }
                this.pools.clear();
            }
            finally {
                this.eventLoopGroup().shutdownGracefully();
            }
        }
        return Futures.asCompletionStage(this.eventLoopGroup().terminationFuture()).thenApply(ignore -> null);
    }

    private ChannelPool getOrCreatePool(BoltServerAddress address) {
        ChannelPool pool = (ChannelPool)this.pools.get(address);
        if (pool == null && this.pools.putIfAbsent(address, pool = this.newPool(address)) != null) {
            pool.close();
            return this.getOrCreatePool(address);
        }
        return pool;
    }

    private NettyChannelPool newPool(BoltServerAddress address) {
        return new NettyChannelPool(address, this.connector, this.bootstrap, this.activeChannelTracker, this.channelHealthChecker, this.settings.connectionAcquisitionTimeout(), this.settings.maxConnectionPoolSize());
    }

    private EventLoopGroup eventLoopGroup() {
        return this.bootstrap.config().group();
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Pool closed");
        }
    }

    private void assertNotClosed(BoltServerAddress address, Channel channel, ChannelPool pool) {
        if (this.closed.get()) {
            pool.release(channel);
            pool.close();
            this.pools.remove(address);
            this.assertNotClosed();
        }
    }
}

