/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.internal.async.ChannelPipelineBuilder;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ReplayingDecoder;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.SecurityException;

public class HandshakeResponseHandler
extends ReplayingDecoder<Void> {
    private final ChannelPipelineBuilder pipelineBuilder;
    private final ChannelPromise handshakeCompletedPromise;
    private final Logging logging;
    private final Logger log;

    public HandshakeResponseHandler(ChannelPipelineBuilder pipelineBuilder, ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedPromise = handshakeCompletedPromise;
        this.logging = logging;
        this.log = logging.getLog(this.getClass().getSimpleName());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        Throwable cause;
        Throwable throwable = cause = error instanceof DecoderException ? error.getCause() : error;
        if (cause instanceof SSLHandshakeException) {
            this.fail(ctx, new SecurityException("Failed to establish secured connection with the server", cause));
        } else {
            this.fail(ctx, cause);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int serverSuggestedVersion = in.readInt();
        this.log.debug("Server suggested protocol version: %s", serverSuggestedVersion);
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove(this);
        switch (serverSuggestedVersion) {
            case 1: {
                PackStreamMessageFormatV1 messageFormat = new PackStreamMessageFormatV1();
                this.pipelineBuilder.build(messageFormat, pipeline, this.logging);
                this.handshakeCompletedPromise.setSuccess();
                break;
            }
            case 0: {
                this.fail(ctx, HandshakeResponseHandler.protocolNoSupportedByServerError());
                break;
            }
            case 1213486160: {
                this.fail(ctx, HandshakeResponseHandler.httpEndpointError());
                break;
            }
            default: {
                this.fail(ctx, HandshakeResponseHandler.protocolNoSupportedByDriverError(serverSuggestedVersion));
            }
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.handshakeCompletedPromise.setFailure(error)));
    }

    private static Throwable protocolNoSupportedByServerError() {
        return new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
    }

    private static Throwable httpEndpointError() {
        return new ClientException("Server responded HTTP. Make sure you are not trying to connect to the http endpoint (HTTP defaults to port 7474 whereas BOLT defaults to port 7687)");
    }

    private static Throwable protocolNoSupportedByDriverError(int suggestedProtocolVersion) {
        return new ClientException("Protocol error, server suggested unexpected protocol version: " + suggestedProtocolVersion);
    }
}

