/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.util.Objects;
import org.neo4j.driver.v1.Logger;

public class DelegatingLogger
implements Logger {
    private final Logger delegate;
    private final String messagePrefix;

    public DelegatingLogger(Logger delegate) {
        this(delegate, null);
    }

    public DelegatingLogger(Logger delegate, String messagePrefix) {
        this.delegate = Objects.requireNonNull(delegate);
        this.messagePrefix = messagePrefix;
    }

    @Override
    public void error(String message, Throwable cause) {
        this.delegate.error(this.messageWithPrefix(message), cause);
    }

    @Override
    public void info(String message, Object ... params) {
        this.delegate.info(this.messageWithPrefix(message), params);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.delegate.warn(this.messageWithPrefix(message), params);
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.delegate.warn(this.messageWithPrefix(message), cause);
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.messageWithPrefix(message), params);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.messageWithPrefix(message), params);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    private String messageWithPrefix(String message) {
        if (this.messagePrefix == null) {
            return message;
        }
        return String.format("[%s] %s", this.messagePrefix, message);
    }
}

