/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.nio.channels.ByteChannel;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.internal.net.BufferingChunkedInput;
import org.neo4j.driver.internal.net.ChunkedOutput;
import org.neo4j.driver.internal.net.SocketProtocol;

public class SocketProtocolV1
implements SocketProtocol {
    private final MessageFormat messageFormat = new PackStreamMessageFormatV1();
    private final MessageFormat.Reader reader;
    private final MessageFormat.Writer writer;

    public static SocketProtocol create(ByteChannel channel) {
        return new SocketProtocolV1(channel, true);
    }

    public static SocketProtocol createWithoutByteArraySupport(ByteChannel channel) {
        return new SocketProtocolV1(channel, false);
    }

    private SocketProtocolV1(ByteChannel channel, boolean byteArraySupportEnabled) {
        this.writer = this.messageFormat.newWriter(new ChunkedOutput(channel), byteArraySupportEnabled);
        this.reader = this.messageFormat.newReader(new BufferingChunkedInput(channel));
    }

    @Override
    public MessageFormat.Reader reader() {
        return this.reader;
    }

    @Override
    public MessageFormat.Writer writer() {
        return this.writer;
    }

    @Override
    public int version() {
        return this.messageFormat.version();
    }
}

