/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.v1.exceptions.ClientException;

public class ChunkedOutput
implements PackOutput {
    public static final short MESSAGE_BOUNDARY = 0;
    public static final int CHUNK_HEADER_SIZE = 2;
    private final ByteBuffer buffer;
    private final WritableByteChannel channel;
    private int currentChunkHeaderOffset;
    private boolean chunkOpen = false;
    private Runnable onMessageComplete = new Runnable(){

        @Override
        public void run() {
            try {
                ChunkedOutput.this.closeChunkIfOpen();
                if (ChunkedOutput.this.buffer.remaining() < 2) {
                    ChunkedOutput.this.flush();
                }
                ChunkedOutput.this.buffer.putShort((short)0);
                ChunkedOutput.this.chunkOpen = false;
            }
            catch (IOException e) {
                throw new ClientException("Error while sending message complete ending '00 00'.", e);
            }
        }
    };

    public ChunkedOutput(WritableByteChannel ch) {
        this(8192, ch);
    }

    public ChunkedOutput(int bufferSize, WritableByteChannel ch) {
        this.buffer = ByteBuffer.allocate(Math.max(16, bufferSize));
        this.chunkOpen = false;
        this.channel = ch;
    }

    @Override
    public PackOutput flush() throws IOException {
        this.closeChunkIfOpen();
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
        return this;
    }

    @Override
    public PackOutput writeByte(byte value) throws IOException {
        this.ensure(1);
        this.buffer.put(value);
        return this;
    }

    @Override
    public PackOutput writeShort(short value) throws IOException {
        this.ensure(2);
        this.buffer.putShort(value);
        return this;
    }

    @Override
    public PackOutput writeInt(int value) throws IOException {
        this.ensure(4);
        this.buffer.putInt(value);
        return this;
    }

    @Override
    public PackOutput writeLong(long value) throws IOException {
        this.ensure(8);
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public PackOutput writeDouble(double value) throws IOException {
        this.ensure(8);
        this.buffer.putDouble(value);
        return this;
    }

    @Override
    public PackOutput writeBytes(byte[] data) throws IOException {
        int amountToWrite;
        int length = data.length;
        for (int offset = 0; offset < length; offset += amountToWrite) {
            this.ensure(1);
            amountToWrite = Math.min(this.buffer.remaining(), length - offset);
            this.buffer.put(data, offset, amountToWrite);
        }
        return this;
    }

    private void closeChunkIfOpen() {
        if (this.chunkOpen) {
            int chunkSize = this.buffer.position() - (this.currentChunkHeaderOffset + 2);
            this.buffer.putShort(this.currentChunkHeaderOffset, (short)chunkSize);
            this.chunkOpen = false;
        }
    }

    private PackOutput ensure(int size) throws IOException {
        int toWriteSize;
        int n = toWriteSize = this.chunkOpen ? size : size + 2;
        if (this.buffer.remaining() < toWriteSize) {
            this.flush();
        }
        if (!this.chunkOpen) {
            this.currentChunkHeaderOffset = this.buffer.position();
            this.buffer.position(this.buffer.position() + 2);
            this.chunkOpen = true;
        }
        return this;
    }

    @Override
    public Runnable messageBoundaryHook() {
        return this.onMessageComplete;
    }
}

