/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RoutingContext {
    public static final RoutingContext EMPTY = new RoutingContext();
    private final Map<String, String> context;

    private RoutingContext() {
        this.context = Collections.emptyMap();
    }

    public RoutingContext(URI uri) {
        this.context = Collections.unmodifiableMap(RoutingContext.parseParameters(uri));
    }

    public boolean isDefined() {
        return !this.context.isEmpty();
    }

    public Map<String, String> asMap() {
        return this.context;
    }

    public String toString() {
        return "RoutingContext" + this.context;
    }

    private static Map<String, String> parseParameters(URI uri) {
        String[] pairs;
        String query = uri.getQuery();
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            String value;
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Invalid parameters: '" + pair + "' in URI '" + uri + "'");
            }
            String key = RoutingContext.trimAndVerify(keyValue[0], "key", uri);
            String previousValue = parameters.put(key, value = RoutingContext.trimAndVerify(keyValue[1], "value", uri));
            if (previousValue == null) continue;
            throw new IllegalArgumentException("Duplicated query parameters with key '" + key + "' in URI '" + uri + "'");
        }
        return parameters;
    }

    private static String trimAndVerify(String string, String name, URI uri) {
        String result = string.trim();
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Illegal empty " + name + " in URI query '" + uri + "'");
        }
        return result;
    }
}

