/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

public class SessionFactoryImpl
implements SessionFactory {
    private final ConnectionProvider connectionProvider;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;

    SessionFactoryImpl(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
    }

    @Override
    public final Session newInstance(AccessMode mode, Bookmark bookmark) {
        NetworkSession session = this.createSession(this.connectionProvider, this.retryLogic, mode, this.logging);
        session.setBookmark(bookmark);
        return session;
    }

    protected NetworkSession createSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, AccessMode mode, Logging logging) {
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(connectionProvider, mode, retryLogic, logging) : new NetworkSession(connectionProvider, mode, retryLogic, logging);
    }

    @Override
    public final void close() throws Exception {
        this.connectionProvider.close();
    }

    public final ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }
}

