/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.AuthenticationException;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.DatabaseException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.util.Function;

public class SocketResponseHandler
implements MessageHandler {
    private final Queue<Collector> collectors = new ConcurrentLinkedQueue<Collector>();
    private Neo4jException error;

    public int collectorsWaiting() {
        return this.collectors.size();
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        Collector collector = this.collectors.element();
        collector.record(fields);
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        String classification;
        Collector collector = this.collectors.remove();
        String[] parts = code.split("\\.");
        switch (classification = parts[1]) {
            case "ClientError": {
                if (code.equalsIgnoreCase("Neo.ClientError.Security.Unauthorized")) {
                    this.error = new AuthenticationException(code, message);
                    break;
                }
                this.error = new ClientException(code, message);
                break;
            }
            case "TransientError": {
                this.error = new TransientException(code, message);
                break;
            }
            default: {
                this.error = new DatabaseException(code, message);
            }
        }
        if (collector != null) {
            collector.doneFailure(this.error);
        }
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        Collector collector = this.collectors.remove();
        this.collectServerVersion(collector, meta.get("server"));
        this.collectFields(collector, meta.get("fields"));
        this.collectType(collector, meta.get("type"));
        this.collectStatistics(collector, meta.get("stats"));
        this.collectPlan(collector, meta.get("plan"));
        this.collectProfile(collector, meta.get("profile"));
        this.collectNotifications(collector, meta.get("notifications"));
        this.collectResultAvailableAfter(collector, meta.get("result_available_after"));
        this.collectResultConsumedAfter(collector, meta.get("result_consumed_after"));
        this.collectBookmark(collector, meta.get("bookmark"));
        collector.doneSuccess();
    }

    private void collectServerVersion(Collector collector, Value serverVersion) {
        if (serverVersion != null) {
            collector.serverVersion(serverVersion.asString());
        }
    }

    private void collectResultAvailableAfter(Collector collector, Value resultAvailableAfter) {
        if (resultAvailableAfter != null) {
            collector.resultAvailableAfter(resultAvailableAfter.asLong());
        }
    }

    private void collectResultConsumedAfter(Collector collector, Value resultConsumedAfter) {
        if (resultConsumedAfter != null) {
            collector.resultConsumedAfter(resultConsumedAfter.asLong());
        }
    }

    private void collectNotifications(Collector collector, Value notifications) {
        if (notifications != null) {
            Function<Value, Notification> notification = InternalNotification.VALUE_TO_NOTIFICATION;
            collector.notifications(notifications.asList(notification));
        }
    }

    private void collectPlan(Collector collector, Value plan) {
        if (plan != null) {
            collector.plan(InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(plan));
        }
    }

    private void collectProfile(Collector collector, Value plan) {
        if (plan != null) {
            collector.profile(InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(plan));
        }
    }

    private void collectFields(Collector collector, Value fieldValue) {
        if (fieldValue != null && !fieldValue.isEmpty()) {
            String[] fields = new String[fieldValue.size()];
            int idx = 0;
            for (Value value : fieldValue.values()) {
                fields[idx++] = value.asString();
            }
            collector.keys(fields);
        }
    }

    private void collectType(Collector collector, Value type) {
        if (type != null) {
            collector.statementType(StatementType.fromCode(type.asString()));
        }
    }

    private void collectStatistics(Collector collector, Value stats) {
        if (stats != null) {
            collector.statementStatistics(new InternalSummaryCounters(this.statsValue(stats, "nodes-created"), this.statsValue(stats, "nodes-deleted"), this.statsValue(stats, "relationships-created"), this.statsValue(stats, "relationships-deleted"), this.statsValue(stats, "properties-set"), this.statsValue(stats, "labels-added"), this.statsValue(stats, "labels-removed"), this.statsValue(stats, "indexes-added"), this.statsValue(stats, "indexes-removed"), this.statsValue(stats, "constraints-added"), this.statsValue(stats, "constraints-removed")));
        }
    }

    private void collectBookmark(Collector collector, Value bookmark) {
        if (bookmark != null) {
            collector.bookmark(Bookmark.from(bookmark.asString()));
        }
    }

    private int statsValue(Value stats, String name) {
        Value value = stats.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    @Override
    public void handleIgnoredMessage() {
        Collector collector = this.collectors.remove();
        if (collector != null) {
            collector.doneIgnored();
        }
    }

    @Override
    public void handleDiscardAllMessage() {
    }

    @Override
    public void handleResetMessage() {
    }

    @Override
    public void handleAckFailureMessage() {
    }

    @Override
    public void handlePullAllMessage() {
    }

    @Override
    public void handleInitMessage(String clientNameAndVersion, Map<String, Value> authToken) {
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Value> parameters) {
    }

    public void appendResultCollector(Collector collector) {
        assert (collector != null);
        this.collectors.add(collector);
    }

    public boolean protocolViolationErrorOccurred() {
        return this.error != null && this.error.code().startsWith("Neo.ClientError.Request");
    }

    public boolean serverFailureOccurred() {
        return this.error != null;
    }

    public Neo4jException serverFailure() {
        return this.error;
    }

    public void clearError() {
        this.error = null;
    }
}

