/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Values;

public class RoutingProcedureRunner {
    static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    static final String GET_ROUTING_TABLE_PARAM = "context";
    static final String GET_ROUTING_TABLE = "dbms.cluster.routing.getRoutingTable({context})";
    private final RoutingContext context;
    private Statement invokedProcedure;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public List<Record> run(Connection connection) {
        this.invokedProcedure = ServerVersion.version(connection.server().version()).greaterThanOrEqual(ServerVersion.v3_2_0) ? new Statement("CALL dbms.cluster.routing.getRoutingTable({context})", Values.parameters(GET_ROUTING_TABLE_PARAM, this.context.asMap())) : new Statement("CALL dbms.cluster.routing.getServers");
        return this.runProcedure(connection, this.invokedProcedure);
    }

    List<Record> runProcedure(Connection connection, Statement procedure) {
        return NetworkSession.run(connection, procedure, SessionResourcesHandler.NO_OP).list();
    }

    Statement invokedProcedure() {
        return this.invokedProcedure;
    }
}

