/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterCompositionResponse;
import org.neo4j.driver.internal.cluster.GetServersProcedureRunner;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ProtocolException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.value.ValueException;

public class GetServersProcedureClusterCompositionProvider
implements ClusterCompositionProvider {
    private final String GET_SERVERS = "dbms.cluster.routing.getServers";
    private final String PROTOCOL_ERROR_MESSAGE = "Failed to parse 'dbms.cluster.routing.getServers' result received from server due to ";
    private final Clock clock;
    private final Logger log;
    private final GetServersProcedureRunner getServersRunner;

    public GetServersProcedureClusterCompositionProvider(Clock clock, Logger log) {
        this(clock, log, new GetServersProcedureRunner());
    }

    GetServersProcedureClusterCompositionProvider(Clock clock, Logger log, GetServersProcedureRunner getServersRunner) {
        this.clock = clock;
        this.log = log;
        this.getServersRunner = getServersRunner;
    }

    @Override
    public ClusterCompositionResponse getClusterComposition(Connection connection) {
        ClusterComposition cluster;
        List<Record> records;
        try {
            records = this.getServersRunner.run(connection);
        }
        catch (ClientException e) {
            return new ClusterCompositionResponse.Failure(new ServiceUnavailableException(String.format("Failed to call '%s' procedure on server. Please make sure that there is a Neo4j 3.1+ causal cluster up running.", "dbms.cluster.routing.getServers"), e));
        }
        this.log.info("Got getServers response: %s", records);
        long now = this.clock.millis();
        if (records.size() != 1) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("%srecords received '%s' is too few or too many.", "Failed to parse 'dbms.cluster.routing.getServers' result received from server due to ", records.size())));
        }
        try {
            cluster = ClusterComposition.parse(records.get(0), now);
        }
        catch (ValueException e) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("%sunparsable record received.", "Failed to parse 'dbms.cluster.routing.getServers' result received from server due to "), e));
        }
        if (!cluster.hasRoutersAndReaders()) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("%sno router or reader found in response.", "Failed to parse 'dbms.cluster.routing.getServers' result received from server due to ")));
        }
        return new ClusterCompositionResponse.Success(cluster);
    }
}

