/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Set;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.GetServersProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoundRobinAddressSet;
import org.neo4j.driver.internal.cluster.RoutingPooledConnection;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ProtocolException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class LoadBalancer
implements ConnectionProvider,
RoutingErrorHandler,
AutoCloseable {
    private static final String LOAD_BALANCER_LOG_NAME = "LoadBalancer";
    private final ConnectionPool connections;
    private final RoutingTable routingTable;
    private final Rediscovery rediscovery;
    private final Logger log;

    public LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connections, Clock clock, Logging logging) {
        this(initialRouter, settings, connections, new ClusterRoutingTable(clock, initialRouter), clock, logging.getLog(LOAD_BALANCER_LOG_NAME));
    }

    private LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connections, RoutingTable routingTable, Clock clock, Logger log) {
        this(connections, routingTable, LoadBalancer.createRediscovery(initialRouter, settings, clock, log), log);
    }

    LoadBalancer(ConnectionPool connections, RoutingTable routingTable, Rediscovery rediscovery, Logger log) {
        this.connections = connections;
        this.routingTable = routingTable;
        this.rediscovery = rediscovery;
        this.log = log;
        this.ensureRouting();
    }

    @Override
    public PooledConnection acquireConnection(AccessMode mode) {
        RoundRobinAddressSet addressSet = this.addressSetFor(mode);
        PooledConnection connection = this.acquireConnection(addressSet);
        return new RoutingPooledConnection(connection, this, mode);
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.removeWriter(address);
    }

    @Override
    public void close() throws Exception {
        this.connections.close();
    }

    private PooledConnection acquireConnection(RoundRobinAddressSet servers) throws ServiceUnavailableException {
        block2: while (true) {
            this.ensureRouting();
            while (true) {
                BoltServerAddress address;
                if ((address = servers.next()) == null) continue block2;
                try {
                    return this.connections.acquire(address);
                }
                catch (ServiceUnavailableException e) {
                    this.log.error("Failed to obtain a connection towards address " + address, e);
                    this.forget(address);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private synchronized void forget(BoltServerAddress address) {
        this.routingTable.forget(address);
        this.connections.purge(address);
    }

    synchronized void ensureRouting() throws ServiceUnavailableException, ProtocolException {
        if (this.routingTable.isStale()) {
            this.log.info("Routing information is stale. %s", this.routingTable);
            ClusterComposition cluster = this.rediscovery.lookupClusterComposition(this.connections, this.routingTable);
            Set<BoltServerAddress> removed = this.routingTable.update(cluster);
            for (BoltServerAddress address : removed) {
                this.connections.purge(address);
            }
            this.log.info("Refreshed routing information. %s", this.routingTable);
        }
    }

    private RoundRobinAddressSet addressSetFor(AccessMode mode) {
        switch (mode) {
            case READ: {
                return this.routingTable.readers();
            }
            case WRITE: {
                return this.routingTable.writers();
            }
        }
        throw new IllegalArgumentException("Mode '" + (Object)((Object)mode) + "' is not supported");
    }

    private static Rediscovery createRediscovery(BoltServerAddress initialRouter, RoutingSettings settings, Clock clock, Logger log) {
        GetServersProcedureClusterCompositionProvider clusterComposition = new GetServersProcedureClusterCompositionProvider(clock, log);
        return new Rediscovery(initialRouter, settings, clock, log, clusterComposition);
    }
}

