/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterCompositionResponse;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.SecurityException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class Rediscovery {
    private static final String NO_ROUTERS_AVAILABLE = "Could not perform discovery. No routing servers available.";
    private final BoltServerAddress initialRouter;
    private final RoutingSettings settings;
    private final Clock clock;
    private final Logger logger;
    private final ClusterCompositionProvider provider;

    public Rediscovery(BoltServerAddress initialRouter, RoutingSettings settings, Clock clock, Logger logger, ClusterCompositionProvider provider) {
        this.initialRouter = initialRouter;
        this.settings = settings;
        this.clock = clock;
        this.logger = logger;
        this.provider = provider;
    }

    public ClusterComposition lookupClusterComposition(ConnectionPool connections, RoutingTable routingTable) {
        int failures = 0;
        long start = this.clock.millis();
        long delay = 0L;
        while (true) {
            long waitTime = start + delay - this.clock.millis();
            this.sleep(waitTime);
            start = this.clock.millis();
            ClusterComposition composition = this.lookupClusterCompositionOnKnownRouters(connections, routingTable);
            if (composition != null) {
                return composition;
            }
            if (++failures >= this.settings.maxRoutingFailures) {
                throw new ServiceUnavailableException(NO_ROUTERS_AVAILABLE);
            }
            delay = Math.max(this.settings.retryTimeoutDelay, delay * 2L);
        }
    }

    private ClusterComposition lookupClusterCompositionOnKnownRouters(ConnectionPool connections, RoutingTable routingTable) {
        BoltServerAddress address;
        boolean triedInitialRouter = false;
        int size = routingTable.routerSize();
        for (int i = 0; i < size && (address = routingTable.nextRouter()) != null; ++i) {
            ClusterComposition composition;
            if (address.equals(this.initialRouter)) {
                triedInitialRouter = true;
            }
            if ((composition = this.lookupClusterCompositionOnRouter(address, connections, routingTable)) == null) continue;
            return composition;
        }
        if (triedInitialRouter) {
            return null;
        }
        return this.lookupClusterCompositionOnRouter(this.initialRouter, connections, routingTable);
    }

    private ClusterComposition lookupClusterCompositionOnRouter(BoltServerAddress routerAddress, ConnectionPool connections, RoutingTable routingTable) {
        ClusterCompositionResponse response;
        try (PooledConnection connection = connections.acquire(routerAddress);){
            response = this.provider.getClusterComposition(connection);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Failed to connect to routing server '%s'.", routerAddress), t);
            routingTable.removeRouter(routerAddress);
            return null;
        }
        ClusterComposition cluster = response.clusterComposition();
        this.logger.info("Got cluster composition %s", cluster);
        if (cluster.hasWriters()) {
            return cluster;
        }
        return null;
    }

    private void sleep(long millis) {
        if (millis > 0L) {
            try {
                this.clock.sleep(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ServiceUnavailableException("Thread was interrupted while performing discovery", e);
            }
        }
    }
}

