/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DirectDriver;
import org.neo4j.driver.internal.LeakLoggingNetworkSessionFactory;
import org.neo4j.driver.internal.NetworkSessionFactory;
import org.neo4j.driver.internal.RoutingDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.SocketConnector;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.SocketConnectionPool;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;

public class DriverFactory {
    public final Driver newInstance(URI uri, AuthToken authToken, RoutingSettings routingSettings, Config config) {
        BoltServerAddress address = BoltServerAddress.from(uri);
        SecurityPlan securityPlan = DriverFactory.createSecurityPlan(address, config);
        ConnectionPool connectionPool = this.createConnectionPool(authToken, securityPlan, config);
        SessionFactory sessionFactory = DriverFactory.createSessionFactory(config);
        try {
            return this.createDriver(address, uri.getScheme(), connectionPool, config, routingSettings, securityPlan, sessionFactory);
        }
        catch (Throwable driverError) {
            try {
                connectionPool.close();
            }
            catch (Throwable closeError) {
                driverError.addSuppressed(closeError);
            }
            throw driverError;
        }
    }

    private Driver createDriver(BoltServerAddress address, String scheme, ConnectionPool connectionPool, Config config, RoutingSettings routingSettings, SecurityPlan securityPlan, SessionFactory sessionFactory) {
        switch (scheme.toLowerCase()) {
            case "bolt": {
                return this.createDirectDriver(address, connectionPool, config, securityPlan, sessionFactory);
            }
            case "bolt+routing": {
                return this.createRoutingDriver(address, connectionPool, config, routingSettings, securityPlan, sessionFactory);
            }
        }
        throw new ClientException(String.format("Unsupported URI scheme: %s", scheme));
    }

    protected DirectDriver createDirectDriver(BoltServerAddress address, ConnectionPool connectionPool, Config config, SecurityPlan securityPlan, SessionFactory sessionFactory) {
        return new DirectDriver(address, connectionPool, securityPlan, sessionFactory, config.logging());
    }

    protected RoutingDriver createRoutingDriver(BoltServerAddress address, ConnectionPool connectionPool, Config config, RoutingSettings routingSettings, SecurityPlan securityPlan, SessionFactory sessionFactory) {
        return new RoutingDriver(routingSettings, address, connectionPool, securityPlan, sessionFactory, this.createClock(), config.logging());
    }

    protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Config config) {
        authToken = authToken == null ? AuthTokens.none() : authToken;
        ConnectionSettings connectionSettings = new ConnectionSettings(authToken, config.connectionTimeoutMillis());
        PoolSettings poolSettings = new PoolSettings(config.maxIdleConnectionPoolSize(), config.idleTimeBeforeConnectionTest());
        Connector connector = this.createConnector(connectionSettings, securityPlan, config.logging());
        return new SocketConnectionPool(poolSettings, connector, this.createClock(), config.logging());
    }

    protected Clock createClock() {
        return Clock.SYSTEM;
    }

    protected Connector createConnector(ConnectionSettings connectionSettings, SecurityPlan securityPlan, Logging logging) {
        return new SocketConnector(connectionSettings, securityPlan, logging);
    }

    private static SessionFactory createSessionFactory(Config config) {
        if (config.logLeakedSessions()) {
            return new LeakLoggingNetworkSessionFactory(config.logging());
        }
        return new NetworkSessionFactory();
    }

    private static SecurityPlan createSecurityPlan(BoltServerAddress address, Config config) {
        try {
            return DriverFactory.createSecurityPlanImpl(address, config);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new ClientException("Unable to establish SSL parameters", ex);
        }
    }

    private static SecurityPlan createSecurityPlanImpl(BoltServerAddress address, Config config) throws GeneralSecurityException, IOException {
        Config.EncryptionLevel encryptionLevel = config.encryptionLevel();
        boolean requiresEncryption = encryptionLevel.equals((Object)Config.EncryptionLevel.REQUIRED);
        if (requiresEncryption) {
            Logger logger = config.logging().getLog("session");
            switch (config.trustStrategy().strategy()) {
                case TRUST_ON_FIRST_USE: {
                    logger.warn("Option `TRUST_ON_FIRST_USE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_ALL_CERTIFICATES` instead.", new Object[0]);
                    return SecurityPlan.forTrustOnFirstUse(config.trustStrategy().certFile(), address, logger);
                }
                case TRUST_SIGNED_CERTIFICATES: {
                    logger.warn("Option `TRUST_SIGNED_CERTIFICATE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_CUSTOM_CA_SIGNED_CERTIFICATES` instead.", new Object[0]);
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forCustomCASignedCertificates(config.trustStrategy().certFile());
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forSystemCASignedCertificates();
                }
                case TRUST_ALL_CERTIFICATES: {
                    return SecurityPlan.forAllCertificates();
                }
            }
            throw new ClientException("Unknown TLS authentication strategy: " + config.trustStrategy().strategy().name());
        }
        return SecurityPlan.insecure();
    }
}

