/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.internal.net.BoltServerAddress;

class RoundRobinAddressSet {
    private static final BoltServerAddress[] NONE = new BoltServerAddress[0];
    private final AtomicInteger offset = new AtomicInteger();
    private volatile BoltServerAddress[] addresses = NONE;

    RoundRobinAddressSet() {
    }

    public int size() {
        return this.addresses.length;
    }

    public BoltServerAddress next() {
        BoltServerAddress[] addresses = this.addresses;
        if (addresses.length == 0) {
            return null;
        }
        return addresses[this.next(addresses.length)];
    }

    int next(int divisor) {
        int index = this.offset.getAndIncrement();
        while (index == Integer.MAX_VALUE) {
            this.offset.compareAndSet(Integer.MIN_VALUE, index % divisor);
            index = this.offset.getAndIncrement();
        }
        return index % divisor;
    }

    public synchronized void update(Set<BoltServerAddress> addresses, Set<BoltServerAddress> removed) {
        BoltServerAddress[] prev = this.addresses;
        if (addresses.isEmpty()) {
            this.addresses = NONE;
            return;
        }
        if (prev.length == 0) {
            this.addresses = addresses.toArray(NONE);
            return;
        }
        BoltServerAddress[] copy = null;
        if (addresses.size() != prev.length) {
            copy = new BoltServerAddress[addresses.size()];
        }
        int j = 0;
        for (int i = 0; i < prev.length; ++i) {
            if (addresses.remove(prev[i])) {
                if (copy == null) continue;
                copy[j++] = prev[i];
                continue;
            }
            removed.add(prev[i]);
            if (copy != null) continue;
            copy = new BoltServerAddress[prev.length];
            System.arraycopy(prev, 0, copy, 0, i);
            j = i;
        }
        if (copy == null) {
            return;
        }
        for (BoltServerAddress address : addresses) {
            copy[j++] = address;
        }
        this.addresses = copy;
    }

    public synchronized void remove(BoltServerAddress address) {
        BoltServerAddress[] addresses = this.addresses;
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].equals(address)) continue;
                if (addresses.length == 1) {
                    this.addresses = NONE;
                    return;
                }
                BoltServerAddress[] copy = new BoltServerAddress[addresses.length - 1];
                System.arraycopy(addresses, 0, copy, 0, i);
                System.arraycopy(addresses, i + 1, copy, i, addresses.length - i - 1);
                this.addresses = copy;
                return;
            }
        }
    }

    void setOffset(int target) {
        this.offset.set(target);
    }
}

