/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

abstract class BaseDriver
implements Driver {
    private static final String DRIVER_LOG_NAME = "Driver";
    private final SecurityPlan securityPlan;
    protected final Logger log;
    private final ReentrantReadWriteLock closedLock = new ReentrantReadWriteLock();
    private boolean closed;

    BaseDriver(SecurityPlan securityPlan, Logging logging) {
        this.securityPlan = securityPlan;
        this.log = logging.getLog(DRIVER_LOG_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEncrypted() {
        this.closedLock.readLock().lock();
        try {
            this.assertOpen();
            boolean bl = this.securityPlan.requiresEncryption();
            return bl;
        }
        finally {
            this.closedLock.readLock().unlock();
        }
    }

    @Override
    public final Session session() {
        return this.session(AccessMode.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Session session(AccessMode mode) {
        this.closedLock.readLock().lock();
        try {
            this.assertOpen();
            Session session = this.newSessionWithMode(mode);
            return session;
        }
        finally {
            this.closedLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        this.closedLock.writeLock().lock();
        try {
            if (!this.closed) {
                this.closeResources();
            }
        }
        finally {
            this.closed = true;
            this.closedLock.writeLock().unlock();
        }
    }

    protected abstract Session newSessionWithMode(AccessMode var1);

    protected abstract void closeResources();

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("This driver instance has already been closed");
        }
    }
}

