/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.io.File;
import java.util.logging.Level;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.util.Immutable;

@Immutable
public class Config {
    private final Logging logging;
    private final int maxIdleConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final EncryptionLevel encryptionLevel;
    private final TrustStrategy trustStrategy;
    private final int minServersInCluster;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.maxIdleConnectionPoolSize = builder.maxIdleConnectionPoolSize;
        this.idleTimeBeforeConnectionTest = builder.idleTimeBeforeConnectionTest;
        this.encryptionLevel = builder.encryptionLevel;
        this.trustStrategy = builder.trustStrategy;
        this.minServersInCluster = builder.minServersInCluster;
    }

    public Logging logging() {
        return this.logging;
    }

    @Deprecated
    public int connectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public int maxIdleConnectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public EncryptionLevel encryptionLevel() {
        return this.encryptionLevel;
    }

    public TrustStrategy trustStrategy() {
        return this.trustStrategy;
    }

    public static ConfigBuilder build() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return Config.build().toConfig();
    }

    public static class TrustStrategy {
        private final Strategy strategy;
        private final File certFile;

        private TrustStrategy(Strategy strategy) {
            this(strategy, null);
        }

        private TrustStrategy(Strategy strategy, File certFile) {
            this.strategy = strategy;
            this.certFile = certFile;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public File certFile() {
            return this.certFile;
        }

        @Deprecated
        public static TrustStrategy trustSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustCustomCertificateSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustSystemCertificates() {
            return new TrustStrategy(Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES);
        }

        public static TrustStrategy trustOnFirstUse(File knownHostsFile) {
            return new TrustStrategy(Strategy.TRUST_ON_FIRST_USE, knownHostsFile);
        }

        public static enum Strategy {
            TRUST_ON_FIRST_USE,
            TRUST_SIGNED_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    public static enum EncryptionLevel {
        NONE,
        REQUIRED_NON_LOCAL,
        REQUIRED;

    }

    public static class ConfigBuilder {
        private Logging logging = new JULogging(Level.INFO);
        private int maxIdleConnectionPoolSize = 10;
        private long idleTimeBeforeConnectionTest = 200L;
        private EncryptionLevel encryptionLevel = EncryptionLevel.REQUIRED_NON_LOCAL;
        private TrustStrategy trustStrategy = TrustStrategy.trustOnFirstUse(new File(System.getProperty("user.home"), ".neo4j" + File.separator + "known_hosts"));
        public int minServersInCluster = 3;

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        @Deprecated
        public ConfigBuilder withMaxSessions(int size) {
            return this;
        }

        public ConfigBuilder withMaxIdleSessions(int size) {
            this.maxIdleConnectionPoolSize = size;
            return this;
        }

        public ConfigBuilder withSessionLivenessCheckTimeout(long timeout) {
            this.idleTimeBeforeConnectionTest = timeout;
            return this;
        }

        public ConfigBuilder withEncryptionLevel(EncryptionLevel level) {
            this.encryptionLevel = level;
            return this;
        }

        public ConfigBuilder withTrustStrategy(TrustStrategy trustStrategy) {
            this.trustStrategy = trustStrategy;
            return this;
        }

        public Config toConfig() {
            return new Config(this);
        }
    }
}

