/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;
import java.util.Set;
import org.neo4j.driver.internal.BaseDriver;
import org.neo4j.driver.internal.ClusterView;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.RoutingNetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.util.Function;

public class RoutingDriver
extends BaseDriver {
    private static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    private static final long MAX_TTL = 9223372036854775L;
    private final ConnectionPool connections;
    private final Function<Connection, Session> sessionProvider;
    private final Clock clock;
    private ClusterView clusterView;

    public RoutingDriver(BoltServerAddress seedAddress, ConnectionPool connections, SecurityPlan securityPlan, Function<Connection, Session> sessionProvider, Clock clock, Logging logging) {
        super(securityPlan, logging);
        this.connections = connections;
        this.sessionProvider = sessionProvider;
        this.clock = clock;
        this.clusterView = new ClusterView(0L, clock, this.log);
        this.clusterView.addRouter(seedAddress);
        this.checkServers();
    }

    private synchronized void checkServers() {
        if (this.clusterView.isStale()) {
            Set<BoltServerAddress> oldAddresses = this.clusterView.all();
            ClusterView newView = this.newClusterView();
            Set<BoltServerAddress> newAddresses = newView.all();
            oldAddresses.removeAll(newAddresses);
            for (BoltServerAddress boltServerAddress : oldAddresses) {
                this.connections.purge(boltServerAddress);
            }
            this.clusterView = newView;
        }
    }

    private long calculateNewExpiry(Record record) {
        long ttl = record.get("ttl").asLong();
        long nextExpiry = this.clock.millis() + 1000L * ttl;
        if (ttl < 0L || ttl >= 9223372036854775L || nextExpiry < 0L) {
            return Long.MAX_VALUE;
        }
        return nextExpiry;
    }

    private ClusterView newClusterView() {
        BoltServerAddress address = null;
        for (int i = 0; i < this.clusterView.numberOfRouters(); ++i) {
            ClusterView newClusterView;
            address = this.clusterView.nextRouter();
            try {
                newClusterView = this.call(address, GET_SERVERS, new Function<Record, ClusterView>(){

                    @Override
                    public ClusterView apply(Record record) {
                        long expire = RoutingDriver.this.calculateNewExpiry(record);
                        ClusterView newClusterView = new ClusterView(expire, RoutingDriver.this.clock, RoutingDriver.this.log);
                        List servers = RoutingDriver.this.servers(record);
                        for (ServerInfo server : servers) {
                            switch (server.role()) {
                                case "READ": {
                                    newClusterView.addReaders(server.addresses());
                                    break;
                                }
                                case "WRITE": {
                                    newClusterView.addWriters(server.addresses());
                                    break;
                                }
                                case "ROUTE": {
                                    newClusterView.addRouters(server.addresses());
                                }
                            }
                        }
                        return newClusterView;
                    }
                });
            }
            catch (Throwable t) {
                this.forget(address);
                continue;
            }
            if (newClusterView.numberOfRouters() == 0) continue;
            return newClusterView;
        }
        this.close();
        throw new ServiceUnavailableException(String.format("Server %s couldn't perform discovery", address == null ? "`UNKNOWN`" : address.toString()));
    }

    private List<ServerInfo> servers(Record record) {
        return record.get("servers").asList(new Function<Value, ServerInfo>(){

            @Override
            public ServerInfo apply(Value value) {
                return new ServerInfo(value.get("addresses").asList(new Function<Value, BoltServerAddress>(){

                    @Override
                    public BoltServerAddress apply(Value value) {
                        return new BoltServerAddress(value.asString());
                    }
                }), value.get("role").asString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T call(BoltServerAddress address, String procedureName, Function<Record, T> recorder) {
        try (Session session = null;){
            Connection acquire = this.connections.acquire(address);
            session = this.sessionProvider.apply(acquire);
            StatementResult records = session.run(String.format("CALL %s", procedureName));
            if (!records.hasNext()) {
                this.forget(address);
                throw new IllegalStateException("Server responded with empty result");
            }
            T t = recorder.apply(records.single());
            return t;
        }
    }

    private synchronized void forget(BoltServerAddress address) {
        this.connections.purge(address);
        this.clusterView.remove(address);
    }

    @Override
    public Session session() {
        return this.session(AccessMode.WRITE);
    }

    @Override
    public Session session(AccessMode mode) {
        Connection connection = this.acquireConnection(mode);
        return new RoutingNetworkSession(new NetworkSession(connection), mode, connection.address(), new RoutingErrorHandler(){

            @Override
            public void onConnectionFailure(BoltServerAddress address) {
                RoutingDriver.this.forget(address);
            }

            @Override
            public void onWriteFailure(BoltServerAddress address) {
                RoutingDriver.this.clusterView.removeWriter(address);
            }
        });
    }

    private Connection acquireConnection(AccessMode role) {
        this.checkServers();
        switch (role) {
            case READ: {
                return this.acquireReadConnection();
            }
            case WRITE: {
                return this.acquireWriteConnection();
            }
        }
        throw new ClientException((Object)((Object)role) + " is not supported for creating new sessions");
    }

    private Connection acquireReadConnection() {
        int numberOfServers = this.clusterView.numberOfReaders();
        for (int i = 0; i < numberOfServers; ++i) {
            BoltServerAddress address = this.clusterView.nextReader();
            try {
                return this.connections.acquire(address);
            }
            catch (ConnectionFailureException e) {
                this.forget(address);
                continue;
            }
        }
        throw new SessionExpiredException("Failed to connect to any read server");
    }

    private Connection acquireWriteConnection() {
        int numberOfServers = this.clusterView.numberOfWriters();
        for (int i = 0; i < numberOfServers; ++i) {
            BoltServerAddress address = this.clusterView.nextWriter();
            try {
                return this.connections.acquire(address);
            }
            catch (ConnectionFailureException e) {
                this.forget(address);
                continue;
            }
        }
        throw new SessionExpiredException("Failed to connect to any write server");
    }

    @Override
    public void close() {
        try {
            this.connections.close();
        }
        catch (Exception ex) {
            this.log.error(String.format("~~ [ERROR] %s", ex.getMessage()), ex);
        }
    }

    public Set<BoltServerAddress> routingServers() {
        return this.clusterView.routingServers();
    }

    public Set<BoltServerAddress> readServers() {
        return this.clusterView.readServers();
    }

    public Set<BoltServerAddress> writeServers() {
        return this.clusterView.writeServers();
    }

    public ConnectionPool connectionPool() {
        return this.connections;
    }

    private static class ServerInfo {
        private final List<BoltServerAddress> addresses;
        private final String role;

        public ServerInfo(List<BoltServerAddress> addresses, String role) {
            this.addresses = addresses;
            this.role = role;
        }

        public String role() {
            return this.role;
        }

        List<BoltServerAddress> addresses() {
            return this.addresses;
        }
    }
}

