/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ConcurrentRoundRobinSet;
import org.neo4j.driver.v1.Logger;

class ClusterView {
    private static final Comparator<BoltServerAddress> COMPARATOR = new Comparator<BoltServerAddress>(){

        @Override
        public int compare(BoltServerAddress o1, BoltServerAddress o2) {
            int compare = o1.host().compareTo(o2.host());
            if (compare == 0) {
                compare = Integer.compare(o1.port(), o2.port());
            }
            return compare;
        }
    };
    private static final int MIN_ROUTERS = 1;
    private final ConcurrentRoundRobinSet<BoltServerAddress> routingServers = new ConcurrentRoundRobinSet<BoltServerAddress>(COMPARATOR);
    private final ConcurrentRoundRobinSet<BoltServerAddress> readServers = new ConcurrentRoundRobinSet<BoltServerAddress>(COMPARATOR);
    private final ConcurrentRoundRobinSet<BoltServerAddress> writeServers = new ConcurrentRoundRobinSet<BoltServerAddress>(COMPARATOR);
    private final Clock clock;
    private final long expires;
    private final Logger log;

    public ClusterView(long expires, Clock clock, Logger log) {
        this.expires = expires;
        this.clock = clock;
        this.log = log;
    }

    public void addRouter(BoltServerAddress router) {
        this.routingServers.add(router);
    }

    public boolean isStale() {
        return this.expires < this.clock.millis() || this.routingServers.size() <= 1 || this.readServers.isEmpty() || this.writeServers.isEmpty();
    }

    Set<BoltServerAddress> all() {
        HashSet<BoltServerAddress> all = new HashSet<BoltServerAddress>(this.routingServers.size() + this.readServers.size() + this.writeServers.size());
        all.addAll(this.routingServers);
        all.addAll(this.readServers);
        all.addAll(this.writeServers);
        return all;
    }

    public BoltServerAddress nextRouter() {
        return this.routingServers.hop();
    }

    public BoltServerAddress nextReader() {
        return this.readServers.hop();
    }

    public BoltServerAddress nextWriter() {
        return this.writeServers.hop();
    }

    public void addReaders(List<BoltServerAddress> addresses) {
        this.readServers.addAll((Collection<BoltServerAddress>)addresses);
    }

    public void addWriters(List<BoltServerAddress> addresses) {
        this.writeServers.addAll((Collection<BoltServerAddress>)addresses);
    }

    public void addRouters(List<BoltServerAddress> addresses) {
        this.routingServers.addAll((Collection<BoltServerAddress>)addresses);
    }

    public void remove(BoltServerAddress address) {
        if (this.routingServers.remove(address)) {
            this.log.debug("Removing %s from routers", address.toString());
        }
        if (this.readServers.remove(address)) {
            this.log.debug("Removing %s from readers", address.toString());
        }
        if (this.writeServers.remove(address)) {
            this.log.debug("Removing %s from writers", address.toString());
        }
    }

    public boolean removeWriter(BoltServerAddress address) {
        return this.writeServers.remove(address);
    }

    public int numberOfRouters() {
        return this.routingServers.size();
    }

    public int numberOfReaders() {
        return this.readServers.size();
    }

    public int numberOfWriters() {
        return this.writeServers.size();
    }

    public Set<BoltServerAddress> routingServers() {
        return Collections.unmodifiableSet(this.routingServers);
    }

    public Set<BoltServerAddress> readServers() {
        return Collections.unmodifiableSet(this.readServers);
    }

    public Set<BoltServerAddress> writeServers() {
        return Collections.unmodifiableSet(this.writeServers);
    }
}

