/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.TrustOnFirstUseTrustManager;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.v1.Logger;

public class SecurityPlan {
    private final boolean requiresEncryption;
    private final SSLContext sslContext;

    public static SecurityPlan forSignedCertificates(File certFile) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
        trustedKeyStore.load(null, null);
        CertificateTool.loadX509Cert(certFile, trustedKeyStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(trustedKeyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), null);
        return new SecurityPlan(true, sslContext);
    }

    public static SecurityPlan forSystemCertificates() throws NoSuchAlgorithmException, KeyStoreException {
        return new SecurityPlan(true, SSLContext.getDefault());
    }

    public static SecurityPlan forTrustOnFirstUse(File knownHosts, BoltServerAddress address, Logger logger) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustOnFirstUseTrustManager(address, knownHosts, logger)}, null);
        return new SecurityPlan(true, sslContext);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlan(false, null);
    }

    private SecurityPlan(boolean requiresEncryption, SSLContext sslContext) {
        this.requiresEncryption = requiresEncryption;
        this.sslContext = sslContext;
    }

    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }
}

