/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;
import org.neo4j.driver.internal.ClusteredErrorHandler;
import org.neo4j.driver.internal.ClusteredNetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.util.Function;

public class ClusteredStatementResult
implements StatementResult {
    private final StatementResult delegate;
    private final AccessMode mode;
    private final BoltServerAddress address;
    private final ClusteredErrorHandler onError;

    ClusteredStatementResult(StatementResult delegate, AccessMode mode, BoltServerAddress address, ClusteredErrorHandler onError) {
        this.delegate = delegate;
        this.mode = mode;
        this.address = address;
        this.onError = onError;
    }

    @Override
    public List<String> keys() {
        try {
            return this.delegate.keys();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.delegate.hasNext();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public Record next() {
        try {
            return this.delegate.next();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public Record single() throws NoSuchRecordException {
        try {
            return this.delegate.single();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public Record peek() {
        try {
            return this.delegate.peek();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public List<Record> list() {
        try {
            return this.delegate.list();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        try {
            return this.delegate.list(mapFunction);
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public void remove() {
        throw new ClientException("Removing records from a result is not supported.");
    }

    @Override
    public ResultSummary consume() {
        try {
            return this.delegate.consume();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }
}

