/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.ClusteredErrorHandler;
import org.neo4j.driver.internal.ClusteredStatementResult;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;

public class ClusteredNetworkSession
extends NetworkSession {
    private final AccessMode mode;
    private final ClusteredErrorHandler onError;

    ClusteredNetworkSession(AccessMode mode, Connection connection, ClusteredErrorHandler onError, Logger logger) {
        super(connection, logger);
        this.mode = mode;
        this.onError = onError;
    }

    @Override
    public StatementResult run(Statement statement) {
        try {
            return new ClusteredStatementResult(super.run(statement), this.mode, this.connection.address(), this.onError);
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.connection.address());
        }
        catch (ClientException e) {
            throw ClusteredNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.connection.address());
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (ConnectionFailureException e) {
            throw ClusteredNetworkSession.sessionExpired(e, this.onError, this.connection.address());
        }
    }

    static Neo4jException filterFailureToWrite(ClientException e, AccessMode mode, ClusteredErrorHandler onError, BoltServerAddress address) {
        if (ClusteredNetworkSession.isFailedToWrite(e)) {
            switch (mode) {
                case READ: {
                    return new ClientException("Write queries cannot be performed in READ access mode.");
                }
                case WRITE: {
                    onError.onWriteFailure(address);
                    return new SessionExpiredException(String.format("Server at %s no longer accepts writes", address));
                }
            }
            throw new IllegalArgumentException((Object)((Object)mode) + " not supported.");
        }
        return e;
    }

    static SessionExpiredException sessionExpired(ConnectionFailureException e, ClusteredErrorHandler onError, BoltServerAddress address) {
        onError.onConnectionFailure(address);
        return new SessionExpiredException(String.format("Server at %s is no longer available", address.toString()), e);
    }

    private static boolean isFailedToWrite(ClientException e) {
        return e.code().equals("Neo.ClientError.Cluster.NotALeader") || e.code().equals("Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

