/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.internal.connector.socket.TrustOnFirstUseTrustManager;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.ClientException;

class SSLContextFactory {
    private final String host;
    private final int port;
    private final Config.TrustStrategy authConfig;
    private final Logger logger;

    SSLContextFactory(String host, int port, Config.TrustStrategy authConfig, Logger logger) {
        this.host = host;
        this.port = port;
        this.authConfig = authConfig;
        this.logger = logger;
    }

    public SSLContext create() throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        switch (this.authConfig.strategy()) {
            case TRUST_SIGNED_CERTIFICATES: {
                this.logger.warn("Option `TRUST_SIGNED_CERTIFICATE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_CUSTOM_CA_SIGNED_CERTIFICATES` instead.", new Object[0]);
            }
            case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
                trustedKeyStore.load(null, null);
                CertificateTool.loadX509Cert(this.authConfig.certFile(), trustedKeyStore);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(trustedKeyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
                break;
            }
            case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                return SSLContext.getDefault();
            }
            case TRUST_ON_FIRST_USE: {
                trustManagers = new TrustManager[]{new TrustOnFirstUseTrustManager(this.host, this.port, this.authConfig.certFile(), this.logger)};
                break;
            }
            default: {
                throw new ClientException("Unknown TLS authentication strategy: " + this.authConfig.strategy().name());
            }
        }
        sslContext.init(new KeyManager[0], trustManagers, null);
        return sslContext;
    }
}

