/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.spi;

import java.util.List;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;

public interface StreamCollector {
    public static final StreamCollector NO_OP = new NoOperationStreamCollector();
    public static final StreamCollector ACK_FAILURE = new NoOperationStreamCollector(){

        @Override
        public void doneFailure(Neo4jException error) {
            throw new ClientException("Invalid server response message `FAILURE` received for client message `ACK_FAILURE`.", error);
        }

        @Override
        public void doneIgnored() {
            throw new ClientException("Invalid server response message `IGNORED` received for client message `ACK_FAILURE`.");
        }
    };
    public static final StreamCollector INIT = new NoOperationStreamCollector(){

        @Override
        public void doneIgnored() {
            throw new ClientException("Invalid server response message `IGNORED` received for client message `INIT`.");
        }
    };
    public static final StreamCollector RESET = new NoOperationStreamCollector(){

        @Override
        public void doneFailure(Neo4jException error) {
            throw new ClientException("Invalid server response message `FAILURE` received for client message `RESET`.", error);
        }

        @Override
        public void doneIgnored() {
            throw new ClientException("Invalid server response message `IGNORED` received for client message `RESET`.");
        }
    };

    public void keys(String[] var1);

    public void record(Value[] var1);

    public void statementType(StatementType var1);

    public void statementStatistics(SummaryCounters var1);

    public void plan(Plan var1);

    public void profile(ProfiledPlan var1);

    public void notifications(List<Notification> var1);

    public void done();

    public void doneSuccess();

    public void doneFailure(Neo4jException var1);

    public void doneIgnored();

    public static class NoOperationStreamCollector
    implements StreamCollector {
        @Override
        public void keys(String[] names) {
        }

        @Override
        public void record(Value[] fields) {
        }

        @Override
        public void statementType(StatementType type) {
        }

        @Override
        public void statementStatistics(SummaryCounters statistics) {
        }

        @Override
        public void plan(Plan plan) {
        }

        @Override
        public void profile(ProfiledPlan plan) {
        }

        @Override
        public void notifications(List<Notification> notifications) {
        }

        @Override
        public void done() {
        }

        @Override
        public void doneSuccess() {
            this.done();
        }

        @Override
        public void doneFailure(Neo4jException error) {
            this.done();
        }

        @Override
        public void doneIgnored() {
            this.done();
        }
    }
}

