/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.xml.bind.DatatypeConverter;

public class CertificateTool {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";

    public static void saveX509Cert(String certStr, File certFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(certFile));
        writer.write(BEGIN_CERT);
        writer.newLine();
        writer.write(certStr);
        writer.newLine();
        writer.write(END_CERT);
        writer.newLine();
        writer.close();
    }

    public static void saveX509Cert(Certificate cert, File certFile) throws GeneralSecurityException, IOException {
        CertificateTool.saveX509Cert(new Certificate[]{cert}, certFile);
    }

    public static void saveX509Cert(Certificate[] certs, File certFile) throws GeneralSecurityException, IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(certFile));
        for (Certificate cert : certs) {
            String certStr = DatatypeConverter.printBase64Binary((byte[])cert.getEncoded()).replaceAll("(.{64})", "$1\n");
            writer.write(BEGIN_CERT);
            writer.newLine();
            writer.write(certStr);
            writer.newLine();
            writer.write(END_CERT);
            writer.newLine();
        }
        writer.close();
    }

    public static void loadX509Cert(File certFile, KeyStore keyStore) throws GeneralSecurityException, IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(certFile));
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        int certCount = 0;
        while (inputStream.available() > 0) {
            try {
                Certificate cert = certFactory.generateCertificate(inputStream);
                CertificateTool.loadX509Cert(cert, "neo4j.javadriver.trustedcert." + ++certCount, keyStore);
            }
            catch (CertificateException e) {
                if (e.getCause() != null && e.getCause().getMessage().equals("Empty input")) {
                    return;
                }
                throw new IOException("Failed to load certificate from `" + certFile.getAbsolutePath() + "`: " + certCount + " : " + e.getMessage(), e);
            }
        }
    }

    public static void loadX509Cert(Certificate cert, String certAlias, KeyStore keyStore) throws KeyStoreException {
        keyStore.setCertificateEntry(certAlias, cert);
    }

    public static String X509CertToString(String cert) {
        String cert64CharPerLine = cert.replaceAll("(.{64})", "$1\n");
        return "-----BEGIN CERTIFICATE-----\n" + cert64CharPerLine + "\n" + END_CERT + "\n";
    }
}

