/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.summary.InternalUpdateStatistics;
import org.neo4j.driver.v1.Notification;
import org.neo4j.driver.v1.Plan;
import org.neo4j.driver.v1.ProfiledPlan;
import org.neo4j.driver.v1.ResultSummary;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementType;
import org.neo4j.driver.v1.UpdateStatistics;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SummaryBuilder
implements StreamCollector {
    private final Statement statement;
    private StatementType type = null;
    private UpdateStatistics statistics = null;
    private Plan plan = null;
    private ProfiledPlan profile;
    private List<Notification> notifications = null;

    public SummaryBuilder(Statement statement) {
        this.statement = statement;
    }

    @Override
    public void keys(String[] names) {
    }

    @Override
    public void record(Value[] fields) {
    }

    @Override
    public void statementType(StatementType type) {
        if (this.type != null) {
            throw new ClientException("Received statement type twice");
        }
        this.type = type;
    }

    @Override
    public void statementStatistics(UpdateStatistics statistics) {
        if (this.statistics != null) {
            throw new ClientException("Received statement statistics twice");
        }
        this.statistics = statistics;
    }

    @Override
    public void plan(Plan plan) {
        if (this.plan != null) {
            throw new ClientException("Received plan twice");
        }
        this.plan = plan;
    }

    @Override
    public void profile(ProfiledPlan plan) {
        if (this.plan != null || this.profile != null) {
            throw new ClientException("Received plan twice");
        }
        this.profile = plan;
        this.plan = plan;
    }

    @Override
    public void notifications(List<Notification> notifications) {
        if (this.notifications != null) {
            throw new ClientException("Received notifications twice");
        }
        this.notifications = notifications;
    }

    @Override
    public void done() {
    }

    public ResultSummary build() {
        return new ResultSummary(){

            @Override
            public Statement statement() {
                return SummaryBuilder.this.statement;
            }

            @Override
            public UpdateStatistics updateStatistics() {
                return SummaryBuilder.this.statistics == null ? InternalUpdateStatistics.EMPTY_STATS : SummaryBuilder.this.statistics;
            }

            @Override
            public StatementType statementType() {
                return SummaryBuilder.this.type;
            }

            @Override
            public boolean hasProfile() {
                return SummaryBuilder.this.profile != null;
            }

            @Override
            public boolean hasPlan() {
                return SummaryBuilder.this.plan != null;
            }

            @Override
            public Plan plan() {
                return SummaryBuilder.this.plan;
            }

            @Override
            public ProfiledPlan profile() {
                return SummaryBuilder.this.profile;
            }

            @Override
            public List<Notification> notifications() {
                return SummaryBuilder.this.notifications == null ? new ArrayList() : SummaryBuilder.this.notifications;
            }
        };
    }
}

