/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.neo4j.driver.internal.logging.JULogger;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.internal.spi.Logging;

public class ConsoleLogging
implements Logging {
    private final ConsoleLogger logger;

    public ConsoleLogging(Level level) {
        this.logger = new ConsoleLogger(this.getClass().getName(), level);
    }

    @Override
    public Logger getLog(String name) {
        return this.logger;
    }

    private static class ShortFormatter
    extends Formatter {
        private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");

        private ShortFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder(1000);
            builder.append(dateFormat.format(new Date(record.getMillis()))).append(" - ");
            builder.append(this.formatMessage(record));
            builder.append("\n");
            return builder.toString();
        }

        @Override
        public String getHead(Handler h) {
            return super.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return super.getTail(h);
        }
    }

    public static class ConsoleLogger
    extends JULogger {
        private final ConsoleHandler handler;

        public ConsoleLogger(String name, Level level) {
            super(name, level);
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
            logger.setUseParentHandlers(false);
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                logger.removeHandler(handlers[i]);
            }
            this.handler = new ConsoleHandler();
            this.handler.setFormatter(new ShortFormatter());
            this.handler.setLevel(level);
            logger.addHandler(this.handler);
            logger.setLevel(level);
        }
    }
}

