/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.driver.internal.InternalRecordAccessor;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Format;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public class InternalRecord
extends InternalRecordAccessor
implements Record {
    private final List<String> keys;
    private final Value[] values;
    private int hashcode = 0;

    public InternalRecord(List<String> keys, Value[] values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public int index(String key) {
        int result = this.keys.indexOf(key);
        if (result == -1) {
            throw new NoSuchElementException("Unknown key: " + key);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public Value get(String key) {
        int fieldIndex = this.keys.indexOf(key);
        if (fieldIndex == -1) {
            return Values.NULL;
        }
        return this.values[fieldIndex];
    }

    @Override
    public Value get(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Record record() {
        return this;
    }

    @Override
    public Map<String, Value> asMap() {
        return Extract.map(this, Values.valueAsIs());
    }

    public String toString() {
        return String.format("Record<%s>", Format.formatPairs(InternalValue.Format.VALUE_WITH_TYPE, this.size(), this.fields()));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Record) {
            Record otherRecord = (Record)other;
            int size = this.size();
            if (size != otherRecord.size()) {
                return false;
            }
            if (!this.keys.equals(otherRecord.keys())) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Value otherValue;
                Value value = this.get(i);
                if (value.equals(otherValue = otherRecord.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashcode() {
        if (this.hashcode == 0) {
            this.hashcode = 31 * this.keys.hashCode() + Arrays.hashCode(this.values);
        }
        return this.hashcode;
    }
}

