/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.io.File;
import java.util.logging.Level;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.internal.spi.Logging;
import org.neo4j.driver.v1.Immutable;

@Immutable
public class Config {
    public static final String SCHEME = "bolt";
    public static final int DEFAULT_PORT = 7687;
    private final Logging logging;
    private final int connectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final boolean isTlsEnabled;
    private TlsAuthenticationConfig tlsAuthConfig;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.connectionPoolSize = builder.connectionPoolSize;
        this.idleTimeBeforeConnectionTest = builder.idleTimeBeforeConnectionTest;
        this.isTlsEnabled = builder.isTlsEnabled;
        this.tlsAuthConfig = builder.tlsAuthConfig;
    }

    public Logging logging() {
        return this.logging;
    }

    public int connectionPoolSize() {
        return this.connectionPoolSize;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public boolean isTlsEnabled() {
        return this.isTlsEnabled;
    }

    public TlsAuthenticationConfig tlsAuthConfig() {
        return this.tlsAuthConfig;
    }

    public static ConfigBuilder build() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return Config.build().toConfig();
    }

    public static class TlsAuthenticationConfig {
        private final Mode mode;
        private final File certFile;

        private TlsAuthenticationConfig(Mode mode, File certFile) {
            this.mode = mode;
            this.certFile = certFile;
        }

        public boolean isFullAuthEnabled() {
            return this.mode == Mode.TRUSTED_CERT;
        }

        public File certFile() {
            return this.certFile;
        }

        public static TlsAuthenticationConfig usingTrustedCert(File certFile) {
            return new TlsAuthenticationConfig(Mode.TRUSTED_CERT, certFile);
        }

        public static TlsAuthenticationConfig usingKnownCerts(File certFile) {
            return new TlsAuthenticationConfig(Mode.KNOWN_CERTS, certFile);
        }

        private static enum Mode {
            KNOWN_CERTS,
            TRUSTED_CERT;

        }
    }

    public static class ConfigBuilder {
        private Logging logging = new JULogging(Level.INFO);
        private int connectionPoolSize = 10;
        private long idleTimeBeforeConnectionTest = 200L;
        private boolean isTlsEnabled = false;
        private TlsAuthenticationConfig tlsAuthConfig = TlsAuthenticationConfig.usingKnownCerts(new File(System.getProperty("user.home"), "neo4j/neo4j_known_certs"));

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public ConfigBuilder withConnectionPoolSize(int size) {
            this.connectionPoolSize = size;
            return this;
        }

        public ConfigBuilder withMinIdleTimeBeforeConnectionTest(long milliSecond) {
            this.idleTimeBeforeConnectionTest = milliSecond;
            return this;
        }

        public ConfigBuilder withTlsEnabled(boolean value) {
            this.isTlsEnabled = value;
            return this;
        }

        public ConfigBuilder withTlsAuthConfig(TlsAuthenticationConfig tlsAuthConfig) {
            this.tlsAuthConfig = tlsAuthConfig;
            return this;
        }

        public Config toConfig() {
            return new Config(this);
        }
    }
}

