/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ScalarValueAdapter;
import org.neo4j.driver.v1.Identity;
import org.neo4j.driver.v1.Type;

public class IdentityValue
extends ScalarValueAdapter {
    private final Identity val;

    public IdentityValue(Identity val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct IdentityValue from null");
        }
        this.val = val;
    }

    @Override
    public Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.IDENTITY();
    }

    @Override
    public Identity asObject() {
        return this.asIdentity();
    }

    @Override
    public Identity asIdentity() {
        return this.val;
    }

    @Override
    public String asLiteralString() {
        return this.val.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityValue values = (IdentityValue)o;
        return this.val == values.val || this.val.equals(values.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }
}

