/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ScalarValueAdapter;
import org.neo4j.driver.v1.Type;

public abstract class BooleanValue
extends ScalarValueAdapter {
    public static BooleanValue TRUE = new TrueValue();
    public static BooleanValue FALSE = new FalseValue();

    private BooleanValue() {
    }

    public static BooleanValue fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public abstract Boolean asObject();

    @Override
    public Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.BOOLEAN();
    }

    @Override
    public int hashCode() {
        Boolean value = this.asBoolean() ? Boolean.TRUE : Boolean.FALSE;
        return value.hashCode();
    }

    private static class FalseValue
    extends BooleanValue {
        private FalseValue() {
        }

        @Override
        public Boolean asObject() {
            return Boolean.FALSE;
        }

        @Override
        public boolean asBoolean() {
            return false;
        }

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == FALSE;
        }

        @Override
        public String asLiteralString() {
            return "FALSE";
        }
    }

    private static class TrueValue
    extends BooleanValue {
        private TrueValue() {
        }

        @Override
        public Boolean asObject() {
            return Boolean.TRUE;
        }

        @Override
        public boolean asBoolean() {
            return true;
        }

        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == TRUE;
        }

        @Override
        public String asLiteralString() {
            return "TRUE";
        }
    }
}

