/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Function;
import org.neo4j.driver.Identity;
import org.neo4j.driver.Node;
import org.neo4j.driver.Path;
import org.neo4j.driver.Relationship;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.value.NotMultiValued;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.exceptions.value.Unsizable;

public abstract class ValueAdapter
implements Value {
    @Override
    public String javaString() {
        throw new Uncoercible(this.typeName(), "Java String");
    }

    @Override
    public int javaInteger() {
        throw new Uncoercible(this.typeName(), "Java int");
    }

    @Override
    public long javaLong() {
        throw new Uncoercible(this.typeName(), "Java long");
    }

    @Override
    public float javaFloat() {
        throw new Uncoercible(this.typeName(), "Java float");
    }

    @Override
    public double javaDouble() {
        throw new Uncoercible(this.typeName(), "Java double");
    }

    @Override
    public boolean javaBoolean() {
        throw new Uncoercible(this.typeName(), "Java boolean");
    }

    @Override
    public <T> List<T> javaList(Function<Value, T> mapFunction) {
        throw new Uncoercible(this.typeName(), "Java List");
    }

    @Override
    public <T> Map<String, T> javaMap(Function<Value, T> mapFunction) {
        throw new Uncoercible(this.typeName(), "Java Map");
    }

    @Override
    public Identity asIdentity() {
        throw new Uncoercible(this.typeName(), "Identity");
    }

    @Override
    public Node asNode() {
        throw new Uncoercible(this.typeName(), "Node");
    }

    @Override
    public Path asPath() {
        throw new Uncoercible(this.typeName(), "Path");
    }

    @Override
    public Relationship asRelationship() {
        throw new Uncoercible(this.typeName(), "Relationship");
    }

    @Override
    public Value get(long index) {
        throw new NotMultiValued(this.typeName() + " is not an indexed collection");
    }

    @Override
    public Value get(String key) {
        throw new NotMultiValued(this.typeName() + " is not a keyed collection");
    }

    @Override
    public long size() {
        throw new Unsizable(this.typeName() + " does not have size");
    }

    @Override
    public Iterable<String> keys() {
        return Collections.emptyList();
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public boolean isPath() {
        return false;
    }

    @Override
    public boolean isRelationship() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public Iterator<Value> iterator() {
        throw new NotMultiValued(this.typeName() + " is not iterable");
    }

    public String toString() {
        return String.format("%s<>", this.typeName());
    }

    protected String typeName() {
        if (this.isFloat()) {
            return "float";
        }
        if (this.isInteger()) {
            return "integer";
        }
        if (this.isBoolean()) {
            return "boolean";
        }
        if (this.isString()) {
            return "string";
        }
        if (this.isList()) {
            return "list";
        }
        if (this.isMap()) {
            return "map";
        }
        if (this.isIdentity()) {
            return "identity";
        }
        if (this.isNode()) {
            return "node";
        }
        if (this.isRelationship()) {
            return "relationship";
        }
        if (this.isPath()) {
            return "path";
        }
        return "unknown";
    }
}

