/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.ValueAdapter;

public class MapValue
extends ValueAdapter {
    private final Map<String, Value> val;

    public MapValue(Map<String, Value> val) {
        this.val = val;
    }

    @Override
    public boolean javaBoolean() {
        return !this.val.isEmpty();
    }

    @Override
    public <T> List<T> javaList(Function<Value, T> mapFunction) {
        ArrayList<T> list = new ArrayList<T>(this.val.size());
        for (Value value : this.val.values()) {
            list.add(mapFunction.apply(value));
        }
        return list;
    }

    @Override
    public <T> Map<String, T> javaMap(Function<Value, T> mapFunction) {
        HashMap<String, T> map = new HashMap<String, T>(this.val.size());
        for (Map.Entry<String, Value> entry : this.val.entrySet()) {
            map.put(entry.getKey(), mapFunction.apply(entry.getValue()));
        }
        return map;
    }

    @Override
    public long size() {
        return this.val.size();
    }

    @Override
    public Iterable<String> keys() {
        return this.val.keySet();
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public Iterator<Value> iterator() {
        final Iterator<Value> raw = this.val.values().iterator();
        return new Iterator<Value>(){

            @Override
            public boolean hasNext() {
                return raw.hasNext();
            }

            @Override
            public Value next() {
                return (Value)raw.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Value get(String key) {
        return this.val.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapValue values = (MapValue)o;
        return !(this.val == null ? values.val != null : !this.val.equals(values.val));
    }

    public int hashCode() {
        return this.val != null ? this.val.hashCode() : 0;
    }

    @Override
    public String toString() {
        return String.format("map<%s>", this.val.toString());
    }
}

