/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Iterator;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.ResultSummary;
import org.neo4j.driver.ReusableResult;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;

public class SimpleResult
implements Result {
    private final Iterable<String> fieldNames;
    private final List<Record> body;
    private final Iterator<Record> iter;
    private final ResultSummary summary;
    private Record current = null;

    public SimpleResult(Iterable<String> fieldNames, List<Record> body, ResultSummary summary) {
        this.fieldNames = fieldNames;
        this.body = body;
        this.iter = body.iterator();
        this.summary = summary;
    }

    @Override
    public ReusableResult retain() {
        return new StandardReusableResult(this.body);
    }

    @Override
    public Record single() {
        return this.iter.next();
    }

    @Override
    public ResultSummary summarize() {
        while (this.next()) {
        }
        return this.summary;
    }

    @Override
    public boolean next() {
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
            return true;
        }
        return false;
    }

    @Override
    public Value get(int fieldIndex) {
        return this.current.get(fieldIndex);
    }

    @Override
    public Value get(String fieldName) {
        if (this.current == null) {
            throw new ClientException("In order to access fields of a record in a result, you must first call next() to point the result to the next record in the result stream.");
        }
        return this.current.get(fieldName);
    }

    @Override
    public Iterable<String> fieldNames() {
        return this.fieldNames;
    }

    private static class StandardReusableResult
    implements ReusableResult {
        private final List<Record> body;

        private StandardReusableResult(List<Record> body) {
            this.body = body;
        }

        @Override
        public long size() {
            return this.body.size();
        }

        @Override
        public Record get(long index) {
            if (index < 0L || index >= (long)this.body.size()) {
                throw new ClientException("Value " + index + " does not exist");
            }
            return this.body.get((int)index);
        }

        @Override
        public Iterator<Record> iterator() {
            return this.body.iterator();
        }
    }
}

