/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Param(Printer printer, ParameterService parameters) implements Command
{
    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0, 1);
        if (args.isEmpty() || "list".equalsIgnoreCase(args.get(0).trim())) {
            this.printer.printOut(this.parameters.pretty());
        } else if ("clear".equalsIgnoreCase(args.get(0).trim())) {
            this.parameters.clear();
        } else {
            try {
                ParameterService.RawParameters parsed = this.parameters.parse(args.get(0));
                this.parameters.setParameters(this.parameters.evaluate(parsed));
            }
            catch (ParameterService.ParameterParsingException e) {
                throw new CommandException(AnsiFormattedText.from("Incorrect usage.\nusage: ").bold(this.metadata().name()).append(" ").append(this.metadata().usage()));
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "Set the specified query parameter to the value given";
            String usage = "list or :param - Lists all parameters\n:param clear - Clears all parameters\n:param {a: 1} - Sets the parameter a to value 1\n:param {a: 1, b: 1+1} - Sets the parameter a to value 1 and b to value 2.\n\nThe arrow syntax `:param a => 1` is also supported to set parameters individually.\n";
            return new Command.Metadata(":param", "Set the value of a query parameter", usage, help, List.of(":params"));
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Param(args.printer(), args.parameters());
        }
    }
}

