/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.shell.Connector;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.Historian;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.UserMessagesHandler;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.exception.UserInterruptException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.util.VisibleForTesting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class InteractiveShellRunner
implements ShellRunner,
CypherShellTerminal.UserInterruptHandler {
    private static final Logger log = Logger.create();
    static final String INTERRUPT_SIGNAL = "INT";
    static final String UNRESOLVED_DEFAULT_DB_PROPMPT_TEXT = "<default_database>";
    static final String DATABASE_UNAVAILABLE_ERROR_PROMPT_TEXT = "[UNAVAILABLE]";
    private static final String FRESH_PROMPT = "> ";
    private static final String TRANSACTION_PROMPT = "# ";
    private static final String USERNAME_DB_DELIMITER = "@";
    private final AtomicBoolean currentlyExecuting;
    private final Printer printer;
    private final CypherShellTerminal terminal;
    private final TransactionHandler txHandler;
    private final DatabaseManager databaseManager;
    private final StatementExecuter executer;
    private final UserMessagesHandler userMessagesHandler;
    private final Connector connector;

    public InteractiveShellRunner(StatementExecuter executer, TransactionHandler txHandler, DatabaseManager databaseManager, Connector connector, Printer printer, CypherShellTerminal terminal, UserMessagesHandler userMessagesHandler, Path historyFile) {
        this.userMessagesHandler = userMessagesHandler;
        this.currentlyExecuting = new AtomicBoolean(false);
        this.executer = executer;
        this.txHandler = txHandler;
        this.databaseManager = databaseManager;
        this.connector = connector;
        this.printer = printer;
        this.terminal = terminal;
        this.setupHistory(historyFile);
        terminal.bindUserInterruptHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runUntilEnd() {
        int exitCode = 0;
        boolean running = true;
        this.printer.printIfVerbose(this.userMessagesHandler.getWelcomeMessage());
        while (running) {
            try {
                for (StatementParser.ParsedStatement statement : this.readUntilStatement()) {
                    this.currentlyExecuting.set(true);
                    this.executer.execute(statement);
                    this.currentlyExecuting.set(false);
                }
            }
            catch (ExitException e) {
                log.info("ExitException code=" + e.getCode() + ", message=" + e.getMessage());
                exitCode = e.getCode();
                running = false;
            }
            catch (NoMoreInputException e) {
                log.info("No more user input.");
                running = false;
            }
            catch (Throwable e) {
                log.error(e);
                this.printer.printError(e);
            }
            finally {
                this.currentlyExecuting.set(false);
            }
        }
        this.printer.printIfVerbose(UserMessagesHandler.getExitMessage());
        this.flushHistory();
        return exitCode;
    }

    @Override
    public Historian getHistorian() {
        return this.terminal.getHistory();
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @VisibleForTesting
    protected List<StatementParser.ParsedStatement> readUntilStatement() throws NoMoreInputException {
        while (true) {
            try {
                return this.terminal.read().readStatement(this.updateAndGetPrompt()).statements();
            }
            catch (UserInterruptException e) {
                log.info("User interrupt.");
                this.handleUserInterrupt();
                continue;
            }
            break;
        }
    }

    private AnsiFormattedText updateAndGetPrompt() {
        String databaseName = this.databaseManager.getActualDatabaseAsReportedByServer();
        if (databaseName == null || "".equals(databaseName)) {
            String dbNameSetByUser = this.databaseManager.getActiveDatabaseAsSetByUser();
            databaseName = "".equals(dbNameSetByUser) ? UNRESOLVED_DEFAULT_DB_PROPMPT_TEXT : dbNameSetByUser;
        }
        String errorSuffix = InteractiveShellRunner.getErrorPrompt(this.executer.lastNeo4jErrorCode());
        int promptIndent = this.connector.username().length() + USERNAME_DB_DELIMITER.length() + databaseName.length() + errorSuffix.length() + FRESH_PROMPT.length();
        AnsiFormattedText prePrompt = this.getPrePrompt(databaseName);
        if (!errorSuffix.isEmpty()) {
            prePrompt.colorRed().append(errorSuffix).colorDefault();
        }
        if (promptIndent <= 50) {
            return prePrompt.append(this.txHandler.isTransactionOpen() ? TRANSACTION_PROMPT : FRESH_PROMPT);
        }
        return prePrompt.appendNewLine().append(this.txHandler.isTransactionOpen() ? TRANSACTION_PROMPT : FRESH_PROMPT);
    }

    private AnsiFormattedText getPrePrompt(String databaseName) {
        AnsiFormattedText prompt = new AnsiFormattedText();
        if (this.connector.isConnected()) {
            prompt.bold(this.connector.username());
            this.connector.impersonatedUser().ifPresent(impersonated -> prompt.append("(").bold((String)impersonated).append(")"));
            prompt.bold(USERNAME_DB_DELIMITER + databaseName);
        } else {
            prompt.append("Disconnected");
        }
        return prompt;
    }

    private static String getErrorPrompt(String errorCode) {
        String errorPromptSuffix = "Neo.TransientError.General.DatabaseUnavailable".equals(errorCode) ? DATABASE_UNAVAILABLE_ERROR_PROMPT_TEXT : "";
        return errorPromptSuffix;
    }

    private void setupHistory(Path historyFile) {
        Path dir = historyFile.getParent();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            this.terminal.setHistoryFile(historyFile);
        } else {
            this.printer.printError("Could not load history file. Falling back to session-based history.\n");
        }
    }

    private void flushHistory() {
        try {
            this.getHistorian().flushHistory();
        }
        catch (IOException e) {
            log.error(e);
            this.printer.printError("Failed to save history: " + e.getMessage());
        }
    }

    @Override
    public void handleUserInterrupt() {
        if (this.currentlyExecuting.get()) {
            this.printer.printError("Stopping query...");
            this.executer.reset();
        } else {
            this.printer.printError(AnsiFormattedText.s().colorRed().append("Interrupted (Note that Cypher queries must end with a ").bold("semicolon").append(". Type ").bold(":exit").append(" to exit the shell.)").formattedString());
        }
    }
}

