/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface Historian {
    public static final Historian empty = new EmptyHistory();

    public List<String> getHistory();

    public void flushHistory() throws IOException;

    public void clear() throws IOException;

    public static File defaultHistoryFile() {
        File dir = new File(System.getProperty("user.home"), ".neo4j");
        return new File(dir, ".cypher_shell_history");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class EmptyHistory
    implements Historian {
        @Override
        public List<String> getHistory() {
            return Collections.emptyList();
        }

        @Override
        public void flushHistory() throws IOException {
        }

        @Override
        public void clear() throws IOException {
        }
    }
}

