/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.neo4j.shell.log.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Build {
    private static final Logger log = Logger.create();
    private static Properties props;

    private static Properties getProperties() {
        if (props == null) {
            props = new Properties();
            try (InputStream stream = Build.class.getClassLoader().getResourceAsStream("build.properties");){
                if (stream == null) {
                    throw new IllegalStateException("Cannot read build.properties");
                }
                props.load(stream);
            }
            catch (IOException e) {
                log.error(e);
                System.err.println("Could not read build properties: " + e.getMessage());
            }
        }
        return props;
    }

    public static String version() {
        return Build.getProperties().getProperty("version", "dev");
    }

    public static String driverVersion() {
        return Build.getProperties().getProperty("driverVersion", "dev");
    }
}

