/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.cypher.internal.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.empty.NullAstFactory;
import org.neo4j.cypher.internal.literal.interpreter.LiteralInterpreter;
import org.neo4j.cypher.internal.parser.javacc.CharStream;
import org.neo4j.cypher.internal.parser.javacc.Cypher;
import org.neo4j.cypher.internal.parser.javacc.CypherCharStream;
import org.neo4j.cypher.internal.parser.javacc.CypherConstants;
import org.neo4j.cypher.internal.parser.javacc.IdentifierTokens;
import org.neo4j.cypher.internal.parser.javacc.ParseException;
import org.neo4j.cypher.internal.parser.javacc.Token;
import org.neo4j.shell.parser.CypherLanguageService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavaCcCypherLanguageService
implements CypherLanguageService {
    @Override
    public List<CypherLanguageService.Token> tokenize(String query) {
        if (query.isEmpty()) {
            return List.of();
        }
        try {
            ArrayList<CypherLanguageService.Token> result = new ArrayList<CypherLanguageService.Token>();
            new TokenIterator(query).forEachRemaining(result::add);
            return result;
        }
        catch (RuntimeException e) {
            return List.of();
        }
    }

    @Override
    public Stream<String> keywords() {
        return this.collectKeywords(IdentifierTokens.getIdentifierTokens().stream());
    }

    @Override
    public List<String> suggestNextKeyword(String incompleteQuery) {
        Set<Integer> tokens = this.suggestNextToken(incompleteQuery, incompleteQuery.length());
        if (tokens.isEmpty()) {
            tokens = this.suggestNextToken(incompleteQuery + " CYPHER", incompleteQuery.length());
        }
        return this.collectKeywords(tokens.stream().filter(this::isIdentifierToken)).toList();
    }

    private Set<Integer> suggestNextToken(String query, int nextOffset) {
        try {
            Cypher cypher = new Cypher((ASTFactory)new NullAstFactory(), (ASTExceptionFactory)new SimpleAstExceptionFactory(), (CharStream)new CypherCharStream(query));
            cypher.Statements();
        }
        catch (ParseSyntaxException e) {
            if (e.offset >= nextOffset && e.parseException.expectedTokenSequences != null) {
                int[][] expected = e.parseException.expectedTokenSequences;
                return Arrays.stream(expected).filter(s -> ((int[])s).length > 0).map(s -> s[0]).collect(Collectors.toSet());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Set.of();
    }

    private Stream<String> collectKeywords(Stream<Integer> tokenKinds) {
        return tokenKinds.filter(kind -> kind != 44).map(kind -> CypherConstants.tokenImage[kind]).filter(image -> image.length() > 2).map(image -> image.substring(1, image.length() - 1));
    }

    private boolean isIdentifierToken(int tokenKind) {
        return IdentifierTokens.getIdentifierTokens().contains(tokenKind);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class TokenIterator
    implements Iterator<CypherLanguageService.Token> {
        private final Cypher cypher;
        private Token current;
        private Token next;

        private TokenIterator(String query) {
            this.cypher = new Cypher((ASTFactory)new LiteralInterpreter(), (ASTExceptionFactory)new SimpleAstExceptionFactory(), (CharStream)new CypherCharStream(query));
            this.next = this.cypher.getNextToken();
        }

        @Override
        public boolean hasNext() {
            return this.next.kind != 0;
        }

        @Override
        public CypherLanguageService.Token next() {
            Token previous = this.current;
            this.current = this.next;
            this.next = this.cypher.getNextToken();
            if (this.current.kind == 271 && previous != null && previous.kind == 96) {
                return new ParameterIdentifierToken(this.current.image, this.current.beginOffset, this.current.endOffset);
            }
            return new SimpleToken(this.current.kind, this.current.image, this.current.beginOffset, this.current.endOffset);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class SimpleAstExceptionFactory
    implements ASTExceptionFactory {
        private SimpleAstExceptionFactory() {
        }

        public Exception syntaxException(String got, List<String> expected, Exception source, int offset, int line, int column) {
            if (source instanceof ParseException) {
                ParseException parseException = (ParseException)source;
                return new ParseSyntaxException(offset, got, parseException);
            }
            return source;
        }

        public Exception syntaxException(Exception source, int offset, int line, int column) {
            return source;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ParseSyntaxException
    extends RuntimeException {
        final int offset;
        final String got;
        final ParseException parseException;

        private ParseSyntaxException(int offset, String got, ParseException parseException) {
            super("", (Throwable)parseException, false, false);
            this.offset = offset;
            this.got = got;
            this.parseException = parseException;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    record ParameterIdentifierToken(String image, int beginOffset, int endOffset) implements CypherLanguageService.Token
    {
        @Override
        public int kind() {
            return 271;
        }

        @Override
        public boolean isParameterIdentifier() {
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    record SimpleToken(int kind, String image, int beginOffset, int endOffset) implements CypherLanguageService.Token
    {
        @Override
        public boolean isParameterIdentifier() {
            return false;
        }
    }
}

