/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.state;

import java.util.Optional;
import org.neo4j.shell.state.LicenseDetailsImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface LicenseDetails {
    public Status status();

    public Optional<Long> daysLeft();

    public Optional<Long> trialDays();

    public static LicenseDetails parse(String status, long daysLeftOnTrial, long totalTrialDays) {
        if ("yes".equals(status)) {
            return LicenseDetailsImpl.YES;
        }
        if ("no".equals(status)) {
            return LicenseDetailsImpl.NO;
        }
        if ("expired".equals(status)) {
            return new LicenseDetailsImpl(Status.EXPIRED, Optional.of(0L), Optional.of(totalTrialDays));
        }
        if ("eval".equals(status)) {
            return new LicenseDetailsImpl(Status.EVAL, Optional.of(daysLeftOnTrial), Optional.of(totalTrialDays));
        }
        throw new IllegalArgumentException("invalid license status " + status);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Status {
        YES,
        NO,
        EVAL,
        EXPIRED;

    }
}

