/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.exception.UserInterruptException;
import org.neo4j.shell.terminal.CypherShellTerminal;

public class Connect
implements Command {
    private static final String COMMAND_NAME = ":connect";
    private final CypherShell shell;
    private final CypherShellTerminal terminal;
    private final ConnectionConfig config;
    private final ArgumentParser argumentParser;

    public Connect(CypherShell shell, CypherShellTerminal terminal, ConnectionConfig config) {
        this.shell = shell;
        this.terminal = terminal;
        this.config = config;
        this.argumentParser = this.setupParser();
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDescription() {
        return "Connects to a database";
    }

    @Override
    public String getUsage() {
        return "[-u USERNAME, --username USERNAME], [-p PASSWORD, --password PASSWORD], [-d DATABASE, --database DATABASE]";
    }

    @Override
    public String getHelp() {
        return String.format(":connect %s, connects to a database", this.getUsage());
    }

    @Override
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public void execute(String argString) throws ExitException, CommandException {
        if (this.shell.isConnected()) {
            throw new CommandException("Already connected");
        }
        this.parseArgString(argString);
        this.shell.connect(this.config);
    }

    private void parseArgString(String argString) throws CommandException {
        try {
            Namespace args = this.argumentParser.parseArgs(CommandHelper.simpleArgParse(argString, 0, 6, COMMAND_NAME, this.getUsage()));
            String user = args.getString("username");
            String password = args.getString("password");
            if (user == null && password != null) {
                throw new CommandException("You cannot provide password only, please provide a username using '-u USERNAME'");
            }
            if (user == null) {
                this.config.setUsername(this.promptForNonEmptyText("username", null));
                this.config.setPassword(this.promptForText("password", Character.valueOf('*')));
            } else if (password == null) {
                this.config.setUsername(user);
                this.config.setPassword(this.promptForText("password", Character.valueOf('*')));
            } else {
                this.config.setUsername(user);
                this.config.setPassword(password);
            }
            this.config.setDatabase(args.getString("database"));
        }
        catch (ArgumentParserException e) {
            throw new CommandException(String.format("Invalid input string: '%s', usage: ':connect %s'", argString, this.getUsage()));
        }
    }

    private ArgumentParser setupParser() {
        ArgumentParser parser = ArgumentParsers.newFor((String)COMMAND_NAME).build();
        parser.addArgument(new String[]{"-d", "--database"}).setDefault((Object)"");
        parser.addArgument(new String[]{"-u", "--username"});
        parser.addArgument(new String[]{"-p", "--password"});
        return parser;
    }

    private String promptForNonEmptyText(String prompt, Character mask) throws CommandException {
        String text = this.promptForText(prompt, mask);
        if (!text.isEmpty()) {
            return text;
        }
        this.terminal.write().println(prompt + " cannot be empty");
        this.terminal.write().println();
        return this.promptForNonEmptyText(prompt, mask);
    }

    private String promptForText(String prompt, Character mask) throws CommandException {
        try {
            return this.terminal.read().simplePrompt(prompt + ": ", mask);
        }
        catch (NoMoreInputException | UserInterruptException e) {
            throw new CommandException("No text could be read, exiting...");
        }
    }
}

