/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.shell.cli.Format;

public class StatisticsCollector {
    private Format format;

    public StatisticsCollector(Format format) {
        this.format = format;
    }

    public String collect(ResultSummary summary) {
        if (Format.VERBOSE == this.format) {
            return StatisticsCollector.collectStatistics(summary);
        }
        return "";
    }

    private static String collectStatistics(ResultSummary summary) {
        ArrayList<String> statistics = new ArrayList<String>();
        SummaryCounters counters = summary.counters();
        if (counters == null) {
            return "";
        }
        if (counters.nodesCreated() != 0) {
            statistics.add(String.format("Added %d nodes", counters.nodesCreated()));
        }
        if (counters.nodesDeleted() != 0) {
            statistics.add(String.format("Deleted %d nodes", counters.nodesDeleted()));
        }
        if (counters.relationshipsCreated() != 0) {
            statistics.add(String.format("Created %d relationships", counters.relationshipsCreated()));
        }
        if (counters.relationshipsDeleted() != 0) {
            statistics.add(String.format("Deleted %d relationships", counters.relationshipsDeleted()));
        }
        if (counters.propertiesSet() != 0) {
            statistics.add(String.format("Set %d properties", counters.propertiesSet()));
        }
        if (counters.labelsAdded() != 0) {
            statistics.add(String.format("Added %d labels", counters.labelsAdded()));
        }
        if (counters.labelsRemoved() != 0) {
            statistics.add(String.format("Removed %d labels", counters.labelsRemoved()));
        }
        if (counters.indexesAdded() != 0) {
            statistics.add(String.format("Added %d indexes", counters.indexesAdded()));
        }
        if (counters.indexesRemoved() != 0) {
            statistics.add(String.format("Removed %d indexes", counters.indexesRemoved()));
        }
        if (counters.constraintsAdded() != 0) {
            statistics.add(String.format("Added %d constraints", counters.constraintsAdded()));
        }
        if (counters.constraintsRemoved() != 0) {
            statistics.add(String.format("Removed %d constraints", counters.constraintsRemoved()));
        }
        return statistics.stream().collect(Collectors.joining(", "));
    }
}

