/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CypherVariablesFormatter {
    private static final String BACKTICK = "`";
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("^[\\p{L}_][\\p{L}0-9_]*");

    private CypherVariablesFormatter() {
    }

    public static String escape(String string) {
        Matcher alphaNumericMatcher = ALPHA_NUMERIC.matcher(string);
        if (!alphaNumericMatcher.matches()) {
            String reEscapeBackTicks = string.replaceAll(BACKTICK, "``");
            return BACKTICK + reEscapeBackTicks + BACKTICK;
        }
        return string;
    }

    public static String unescapedCypherVariable(String string) {
        Matcher alphaNumericMatcher = ALPHA_NUMERIC.matcher(string);
        if (!alphaNumericMatcher.matches()) {
            String substring = string.substring(1, string.length() - 1);
            return substring.replace("``", BACKTICK);
        }
        return string;
    }
}

