/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jline.terminal.Attributes;
import org.jline.terminal.impl.ExecPty;
import org.neo4j.shell.terminal.StreamPrompt;
import org.neo4j.util.VisibleForTesting;

class TtyPrompt
extends StreamPrompt {
    private final ExecPty pty;
    private final Attributes originalAttributes;
    private final Thread shutdownThread;
    private final Charset charset;

    TtyPrompt(ExecPty pty) throws IOException {
        this(pty, new FileInputStream(pty.getName()), new FileOutputStream(pty.getName()), Charset.defaultCharset());
    }

    @VisibleForTesting
    TtyPrompt(ExecPty pty, InputStream in, OutputStream out, Charset defaultCharset) throws IOException {
        this(pty, in, out, pty.getAttr(), TtyPrompt.getCharset(pty.getAttr(), defaultCharset));
    }

    private TtyPrompt(ExecPty pty, InputStream in, OutputStream out, Attributes originalAttributes, Charset charset) {
        super(in, new PrintWriter(out, false, charset));
        this.pty = pty;
        this.originalAttributes = originalAttributes;
        this.charset = charset;
        this.shutdownThread = new Thread(this::tryRestoringTerminal);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    private static Charset getCharset(Attributes attributes, Charset defaultCharset) {
        return attributes.getInputFlag(Attributes.InputFlag.IUTF8) ? StandardCharsets.UTF_8 : defaultCharset;
    }

    @Override
    protected void disableEcho() throws IOException {
        Attributes attrs = this.pty.getAttr();
        attrs.setLocalFlag(Attributes.LocalFlag.ECHO, false);
        this.pty.setAttr(attrs);
    }

    @Override
    protected void restoreTerminal() throws IOException {
        this.pty.setAttr(this.originalAttributes);
    }

    private void tryRestoringTerminal() {
        try {
            this.restoreTerminal();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Charset charset() {
        return this.charset;
    }

    @Override
    public void close() throws Exception {
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        this.pty.close();
    }
}

