/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.state;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Connector;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.TriFunction;
import org.neo4j.shell.build.Build;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ThrowingAction;
import org.neo4j.shell.log.NullLogging;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.state.ErrorWhileInTransactionException;
import org.neo4j.shell.state.StatementBoltResult;
import org.neo4j.shell.util.Versions;

public class BoltStateHandler
implements TransactionHandler,
Connector,
DatabaseManager {
    private static final String USER_AGENT = "neo4j-cypher-shell/v" + Build.version();
    private final TriFunction<String, AuthToken, Config, Driver> driverProvider;
    private final boolean isInteractive;
    private final Map<String, Bookmark> bookmarks = new HashMap<String, Bookmark>();
    protected Driver driver;
    Session session;
    private String version;
    private String activeDatabaseNameAsSetByUser;
    private String actualDatabaseNameAsReportedByServer;
    private Transaction tx;

    public BoltStateHandler(boolean isInteractive) {
        this(GraphDatabase::driver, isInteractive);
    }

    BoltStateHandler(TriFunction<String, AuthToken, Config, Driver> driverProvider, boolean isInteractive) {
        this.driverProvider = driverProvider;
        this.activeDatabaseNameAsSetByUser = "";
        this.isInteractive = isInteractive;
    }

    @Override
    public void setActiveDatabase(String databaseName) throws CommandException {
        if (this.isTransactionOpen()) {
            throw new CommandException("There is an open transaction. You need to close it before you can switch database.");
        }
        String previousDatabaseName = this.activeDatabaseNameAsSetByUser;
        this.activeDatabaseNameAsSetByUser = databaseName;
        try {
            if (this.isConnected()) {
                this.reconnect(databaseName, previousDatabaseName);
            }
        }
        catch (ClientException e) {
            if (this.isInteractive) {
                this.activeDatabaseNameAsSetByUser = previousDatabaseName;
                try {
                    this.reconnect(previousDatabaseName, previousDatabaseName);
                }
                catch (Exception e2) {
                    e.addSuppressed((Throwable)e2);
                }
            }
            throw e;
        }
    }

    @Override
    public String getActiveDatabaseAsSetByUser() {
        return this.activeDatabaseNameAsSetByUser;
    }

    @Override
    public String getActualDatabaseAsReportedByServer() {
        return this.actualDatabaseNameAsReportedByServer;
    }

    @Override
    public void beginTransaction() throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (this.isTransactionOpen()) {
            throw new CommandException("There is already an open transaction");
        }
        this.tx = this.session.beginTransaction();
    }

    @Override
    public void commitTransaction() throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (!this.isTransactionOpen()) {
            throw new CommandException("There is no open transaction to commit");
        }
        try {
            this.tx.commit();
            this.tx.close();
        }
        finally {
            this.tx = null;
        }
    }

    @Override
    public void rollbackTransaction() throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (!this.isTransactionOpen()) {
            throw new CommandException("There is no open transaction to rollback");
        }
        try {
            this.tx.rollback();
            this.tx.close();
        }
        finally {
            this.tx = null;
        }
    }

    public Neo4jException handleException(Neo4jException e) {
        if (this.isTransactionOpen()) {
            this.tx.close();
            this.tx = null;
            return new ErrorWhileInTransactionException("An error occurred while in an open transaction. The transaction will be rolled back and terminated. Error: " + e.getMessage(), e);
        }
        return e;
    }

    @Override
    public boolean isTransactionOpen() {
        return this.tx != null;
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public void connect(@Nonnull ConnectionConfig connectionConfig, ThrowingAction<CommandException> command) throws CommandException {
        if (this.isConnected()) {
            throw new CommandException("Already connected");
        }
        AuthToken authToken = AuthTokens.basic((String)connectionConfig.username(), (String)connectionConfig.password());
        try {
            String previousDatabaseName = this.activeDatabaseNameAsSetByUser;
            try {
                this.activeDatabaseNameAsSetByUser = connectionConfig.database();
                this.driver = this.getDriver(connectionConfig, authToken);
                this.reconnect(this.activeDatabaseNameAsSetByUser, previousDatabaseName, command);
            }
            catch (ServiceUnavailableException e) {
                String fallbackScheme;
                String scheme;
                switch (scheme = connectionConfig.scheme()) {
                    case "neo4j": {
                        fallbackScheme = "bolt";
                        break;
                    }
                    case "neo4j+ssc": {
                        fallbackScheme = "bolt+ssc";
                        break;
                    }
                    case "neo4j+s": {
                        fallbackScheme = "bolt+s";
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
                connectionConfig = new ConnectionConfig(fallbackScheme, connectionConfig.host(), connectionConfig.port(), connectionConfig.username(), connectionConfig.password(), connectionConfig.encryption(), connectionConfig.database());
                this.driver = this.getDriver(connectionConfig, authToken);
                this.reconnect(this.activeDatabaseNameAsSetByUser, previousDatabaseName, command);
            }
        }
        catch (Throwable t) {
            try {
                this.silentDisconnect();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private void reconnect(String databaseToConnectTo, String previousDatabase) throws CommandException {
        this.reconnect(databaseToConnectTo, previousDatabase, null);
    }

    private void reconnect(String databaseToConnectTo, String previousDatabase, ThrowingAction<CommandException> command) throws CommandException {
        SessionConfig.Builder builder = SessionConfig.builder();
        builder.withDefaultAccessMode(AccessMode.WRITE);
        if (!"".equals(databaseToConnectTo)) {
            builder.withDatabase(databaseToConnectTo);
        }
        this.closeSession(previousDatabase);
        Bookmark bookmarkForDBToConnectTo = this.bookmarks.get(databaseToConnectTo);
        if (bookmarkForDBToConnectTo != null) {
            builder.withBookmarks(new Bookmark[]{bookmarkForDBToConnectTo});
        }
        this.session = this.driver.session(builder.build());
        this.resetActualDbName();
        this.connect(command);
    }

    private void closeSession(String databaseName) {
        if (this.session != null) {
            Bookmark bookmarkForPreviousDB = this.session.lastBookmark();
            this.session.close();
            this.bookmarks.put(databaseName, bookmarkForPreviousDB);
        }
    }

    private void connect(ThrowingAction<CommandException> command) throws CommandException {
        ThrowingAction<CommandException> toCall = command == null ? this.getPing() : () -> {
            try {
                command.apply();
            }
            catch (Neo4jException e) {
                if (Versions.isPasswordChangeRequiredException(e)) {
                    this.getPing().apply();
                }
                throw e;
            }
        };
        toCall.apply();
    }

    private ThrowingAction<CommandException> getPing() {
        return () -> {
            block7: {
                ResultSummary summary = null;
                Result run = this.session.run("CALL db.ping()");
                try {
                    summary = run.consume();
                }
                catch (ClientException e) {
                    if (this.procedureNotFound(e)) {
                        run = this.session.run(this.isSystemDb() ? "CALL db.indexes()" : "RETURN 1");
                        break block7;
                    }
                    throw e;
                }
                finally {
                    if (summary == null) {
                        summary = run.consume();
                    }
                    this.version = summary.server().version();
                    this.updateActualDbName(summary);
                }
            }
        };
    }

    @Override
    @Nonnull
    public String getServerVersion() {
        if (this.isConnected()) {
            if (this.version == null) {
                this.version = "";
            }
            if (this.version.startsWith("Neo4j/")) {
                this.version = this.version.substring(6);
            }
            return this.version;
        }
        return "";
    }

    @Nonnull
    public Optional<BoltResult> runCypher(@Nonnull String cypher, @Nonnull Map<String, Object> queryParams) throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (this.isTransactionOpen()) {
            return this.getBoltResult(cypher, queryParams);
        }
        try {
            return this.getBoltResult(cypher, queryParams);
        }
        catch (SessionExpiredException e) {
            this.reconnect(this.activeDatabaseNameAsSetByUser, this.activeDatabaseNameAsSetByUser);
            return this.getBoltResult(cypher, queryParams);
        }
    }

    public void updateActualDbName(@Nonnull ResultSummary resultSummary) {
        this.actualDatabaseNameAsReportedByServer = this.getActualDbName(resultSummary);
    }

    public void changePassword(@Nonnull ConnectionConfig connectionConfig) {
        if (!connectionConfig.passwordChangeRequired()) {
            return;
        }
        if (this.isConnected()) {
            this.silentDisconnect();
        }
        AuthToken authToken = AuthTokens.basic((String)connectionConfig.username(), (String)connectionConfig.password());
        try {
            Value parameters;
            String command;
            this.driver = this.getDriver(connectionConfig, authToken);
            this.activeDatabaseNameAsSetByUser = "system";
            this.reconnect("system", "system", () -> {});
            if (Versions.majorVersion(this.getServerVersion()) >= 4) {
                command = "ALTER CURRENT USER SET PASSWORD FROM $o TO $n";
                parameters = Values.parameters((Object[])new Object[]{"o", connectionConfig.password(), "n", connectionConfig.newPassword()});
            } else {
                command = "CALL dbms.security.changePassword($n)";
                parameters = Values.parameters((Object[])new Object[]{"n", connectionConfig.newPassword()});
            }
            Result run = this.session.run(command, parameters);
            run.consume();
            connectionConfig.setPassword(connectionConfig.newPassword());
            connectionConfig.setNewPassword(null);
            this.silentDisconnect();
        }
        catch (Throwable t) {
            try {
                this.silentDisconnect();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    @Nonnull
    private Optional<BoltResult> getBoltResult(@Nonnull String cypher, @Nonnull Map<String, Object> queryParams) throws SessionExpiredException {
        Result statementResult = this.isTransactionOpen() ? this.tx.run(new Query(cypher, queryParams)) : this.session.run(new Query(cypher, queryParams));
        if (statementResult == null) {
            return Optional.empty();
        }
        return Optional.of(new StatementBoltResult(statementResult));
    }

    private String getActualDbName(@Nonnull ResultSummary resultSummary) {
        DatabaseInfo dbInfo = resultSummary.database();
        return dbInfo.name() == null ? "" : dbInfo.name();
    }

    private void resetActualDbName() {
        this.actualDatabaseNameAsReportedByServer = null;
    }

    void silentDisconnect() {
        try {
            this.closeSession(this.activeDatabaseNameAsSetByUser);
            if (this.driver != null) {
                this.driver.close();
            }
        }
        finally {
            this.session = null;
            this.driver = null;
            this.resetActualDbName();
        }
    }

    public void reset() {
        if (this.isConnected()) {
            this.session.reset();
            if (this.isTransactionOpen()) {
                this.tx.rollback();
                this.tx.close();
                this.tx = null;
            }
        }
    }

    public void disconnect() {
        this.reset();
        this.silentDisconnect();
        this.version = null;
    }

    private Driver getDriver(@Nonnull ConnectionConfig connectionConfig, @Nullable AuthToken authToken) {
        Config.ConfigBuilder configBuilder = Config.builder().withLogging(NullLogging.NULL_LOGGING).withUserAgent(USER_AGENT);
        switch (connectionConfig.encryption()) {
            case TRUE: {
                configBuilder = configBuilder.withEncryption();
                break;
            }
            case FALSE: {
                configBuilder = configBuilder.withoutEncryption();
                break;
            }
        }
        return this.driverProvider.apply(connectionConfig.driverUrl(), authToken, configBuilder.build());
    }

    private List<BoltResult> executeWithRetry(List<Query> transactionStatements, BiFunction<Query, Transaction, BoltResult> biFunction) {
        return (List)this.session.writeTransaction(tx -> transactionStatements.stream().map(transactionStatement -> (BoltResult)biFunction.apply((Query)transactionStatement, tx)).collect(Collectors.toList()));
    }

    private boolean isSystemDb() {
        return this.activeDatabaseNameAsSetByUser.compareToIgnoreCase("system") == 0;
    }

    private boolean procedureNotFound(ClientException e) {
        return e.code().compareToIgnoreCase("Neo.ClientError.Procedure.ProcedureNotFound") == 0;
    }
}

