/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.neo4j.shell.parser.StatementParser;

public class ShellStatementParser
implements StatementParser {
    private static final Pattern SHELL_CMD_PATTERN = Pattern.compile("^\\s*:.+\\s*$");
    private static final char SEMICOLON = ';';
    private static final char BACKSLASH = '\\';
    private static final String LINE_COMMENT_START = "//";
    private static final String LINE_COMMENT_END = "\n";
    private static final String BLOCK_COMMENT_START = "/*";
    private static final String BLOCK_COMMENT_END = "*/";
    private static final char BACKTICK = '`';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final int NO_COMMENT = -1;
    private Optional<String> awaitedRightDelimiter;
    private StringBuilder statement;
    private ArrayList<String> parsedStatements = new ArrayList();
    private int commentStart = -1;

    public ShellStatementParser() {
        this.statement = new StringBuilder();
        this.awaitedRightDelimiter = Optional.empty();
    }

    @Override
    public void parseMoreText(@Nonnull String line) {
        if (this.statementNotStarted() && SHELL_CMD_PATTERN.matcher(line).find()) {
            this.parsedStatements.add(line);
            return;
        }
        boolean skipNext = false;
        char current = '\u0000';
        for (char c : line.toCharArray()) {
            this.statement.append(c);
            char prev = current;
            current = c;
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (this.handleComments(prev, current)) continue;
            if (current == '\\') {
                skipNext = true;
                continue;
            }
            if (this.handleQuotes(prev, current) || this.handleSemicolon(current)) continue;
            this.awaitedRightDelimiter = this.getRightDelimiter(prev, current);
        }
    }

    private boolean handleSemicolon(char current) {
        if (current == ';') {
            this.parsedStatements.add(this.statement.toString());
            this.statement = new StringBuilder();
            return true;
        }
        return false;
    }

    private boolean handleQuotes(char prev, char current) {
        if (this.inQuote()) {
            if (this.isRightDelimiter(prev, current)) {
                this.awaitedRightDelimiter = Optional.empty();
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean handleComments(char prev, char current) {
        if (this.inComment()) {
            if (this.commentStart == -1) {
                this.commentStart = this.statement.length() - 3;
            }
            if (this.isRightDelimiter(prev, current)) {
                this.awaitedRightDelimiter = Optional.empty();
                this.statement.delete(this.commentStart, this.statement.length());
                this.commentStart = -1;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean inQuote() {
        return this.awaitedRightDelimiter.isPresent() && !this.inComment();
    }

    private boolean isRightDelimiter(char first, char last) {
        if (!this.awaitedRightDelimiter.isPresent()) {
            return false;
        }
        String expectedEnd = this.awaitedRightDelimiter.get();
        if (expectedEnd.length() == 1) {
            return expectedEnd.equals(String.valueOf(last));
        }
        return expectedEnd.equals(String.valueOf(first) + last);
    }

    private boolean inComment() {
        return this.awaitedRightDelimiter.isPresent() && (this.awaitedRightDelimiter.get().equals(LINE_COMMENT_END) || this.awaitedRightDelimiter.get().equals(BLOCK_COMMENT_END));
    }

    @Nonnull
    private Optional<String> getRightDelimiter(char first, char last) {
        String lastTwoChars;
        switch (lastTwoChars = String.valueOf(first) + last) {
            case "//": {
                return Optional.of(LINE_COMMENT_END);
            }
            case "/*": {
                return Optional.of(BLOCK_COMMENT_END);
            }
        }
        switch (last) {
            case '\"': 
            case '\'': 
            case '`': {
                return Optional.of(String.valueOf(last));
            }
        }
        return Optional.empty();
    }

    private boolean statementNotStarted() {
        return this.statement.toString().trim().isEmpty();
    }

    @Override
    public boolean hasStatements() {
        return !this.parsedStatements.isEmpty();
    }

    @Override
    @Nonnull
    public List<String> consumeStatements() {
        ArrayList<String> result = this.parsedStatements;
        this.parsedStatements = new ArrayList();
        return result;
    }

    @Override
    public boolean containsText() {
        return !this.statement.toString().trim().isEmpty();
    }

    @Override
    public void reset() {
        this.statement = new StringBuilder();
        this.parsedStatements.clear();
        this.awaitedRightDelimiter = Optional.empty();
    }
}

