/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.Evaluator;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;
import org.neo4j.shell.state.ParamValue;

public class ShellParameterMap
implements ParameterMap {
    private final Map<String, ParamValue> queryParams = new HashMap<String, ParamValue>();
    private ExpressionEvaluator evaluator = Evaluator.expressionEvaluator();

    @Override
    public Object setParameter(@Nonnull String name, @Nonnull String valueString) throws EvaluationException {
        String parameterName = CypherVariablesFormatter.unescapedCypherVariable(name);
        Object value = this.evaluator.evaluate(valueString, Object.class);
        this.queryParams.put(parameterName, new ParamValue(valueString, value));
        return value;
    }

    @Override
    @Nonnull
    public Map<String, Object> allParameterValues() {
        return this.queryParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((ParamValue)value.getValue()).getValue()));
    }

    @Override
    @Nonnull
    public Map<String, ParamValue> getAllAsUserInput() {
        return this.queryParams;
    }
}

