/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jline.console.ConsoleReader;
import org.neo4j.driver.v1.exceptions.AuthenticationException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.build.Build;
import org.neo4j.shell.cli.CliArgHelper;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.AnsiLogger;
import org.neo4j.shell.prettyprint.PrettyConfig;

public class Main {
    static final String NEO_CLIENT_ERROR_SECURITY_UNAUTHORIZED = "Neo.ClientError.Security.Unauthorized";
    private final InputStream in;
    private final PrintStream out;
    private final boolean hasSpecialInteractiveOutputStream;

    Main() {
        this(System.in, System.out, false);
    }

    Main(InputStream in, PrintStream out) {
        this(in, out, true);
    }

    private Main(InputStream in, PrintStream out, boolean hasSpecialInteractiveOutputStream) {
        this.in = in;
        this.out = out;
        this.hasSpecialInteractiveOutputStream = hasSpecialInteractiveOutputStream;
    }

    public static void main(String[] args) {
        CliArgs cliArgs = CliArgHelper.parse(args);
        if (cliArgs == null) {
            System.exit(1);
        }
        Main main = new Main();
        main.startShell(cliArgs);
    }

    private OutputStream getOutputStreamForInteractivePrompt() {
        return this.hasSpecialInteractiveOutputStream ? this.out : ShellRunner.getOutputStreamForInteractivePrompt();
    }

    void startShell(@Nonnull CliArgs cliArgs) {
        if (cliArgs.getVersion()) {
            this.out.println("Cypher-Shell " + Build.version());
        }
        if (cliArgs.getDriverVersion()) {
            this.out.println("Neo4j Driver " + Build.driverVersion());
        }
        if (cliArgs.getVersion() || cliArgs.getDriverVersion()) {
            return;
        }
        AnsiLogger logger = new AnsiLogger(cliArgs.getDebugMode());
        PrettyConfig prettyConfig = new PrettyConfig(cliArgs);
        ConnectionConfig connectionConfig = new ConnectionConfig(cliArgs.getScheme(), cliArgs.getHost(), cliArgs.getPort(), cliArgs.getUsername(), cliArgs.getPassword(), cliArgs.getEncryption());
        try {
            CypherShell shell = new CypherShell(logger, prettyConfig);
            this.connectMaybeInteractively(shell, connectionConfig, ShellRunner.isInputInteractive(), ShellRunner.isOutputInteractive());
            ShellRunner shellRunner = ShellRunner.getShellRunner(cliArgs, shell, logger, connectionConfig);
            CommandHelper commandHelper = new CommandHelper(logger, shellRunner.getHistorian(), shell);
            shell.setCommandHelper(commandHelper);
            int code = shellRunner.runUntilEnd();
            System.exit(code);
        }
        catch (Throwable e) {
            logger.printError(e);
            System.exit(1);
        }
    }

    void connectMaybeInteractively(@Nonnull CypherShell shell, @Nonnull ConnectionConfig connectionConfig, boolean inputInteractive, boolean outputInteractive) throws Exception {
        boolean didPrompt = false;
        if (inputInteractive && !connectionConfig.username().isEmpty() && connectionConfig.password().isEmpty()) {
            this.promptForUsernameAndPassword(connectionConfig, outputInteractive);
            didPrompt = true;
        }
        try {
            shell.connect(connectionConfig);
        }
        catch (AuthenticationException e) {
            if (didPrompt || !inputInteractive || !connectionConfig.username().isEmpty() && !connectionConfig.password().isEmpty()) {
                throw e;
            }
            this.promptForUsernameAndPassword(connectionConfig, outputInteractive);
            shell.connect(connectionConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptForUsernameAndPassword(ConnectionConfig connectionConfig, boolean outputInteractive) throws Exception {
        OutputStream promptOutputStream = this.getOutputStreamForInteractivePrompt();
        ConsoleReader consoleReader = new ConsoleReader(this.in, promptOutputStream);
        consoleReader.setExpandEvents(false);
        consoleReader.setHandleUserInterrupt(false);
        try {
            if (connectionConfig.username().isEmpty()) {
                String username = outputInteractive ? this.promptForNonEmptyText("username", consoleReader, null) : this.promptForText("username", consoleReader, null);
                connectionConfig.setUsername(username);
            }
            if (connectionConfig.password().isEmpty()) {
                connectionConfig.setPassword(this.promptForText("password", consoleReader, Character.valueOf('*')));
            }
        }
        finally {
            consoleReader.close();
        }
    }

    @Nonnull
    private String promptForNonEmptyText(@Nonnull String prompt, @Nonnull ConsoleReader consoleReader, @Nullable Character mask) throws Exception {
        String text = this.promptForText(prompt, consoleReader, mask);
        if (!text.isEmpty()) {
            return text;
        }
        consoleReader.println((CharSequence)(prompt + " cannot be empty"));
        consoleReader.println();
        return this.promptForNonEmptyText(prompt, consoleReader, mask);
    }

    @Nonnull
    private String promptForText(@Nonnull String prompt, @Nonnull ConsoleReader consoleReader, @Nullable Character mask) throws Exception {
        String line = consoleReader.readLine(prompt + ": ", mask);
        if (line == null) {
            throw new CommandException("No text could be read, exiting...");
        }
        return line;
    }
}

