/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.types.TypeRepresentation;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.values.storable.DurationValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface OutputFormatter {
    public static final String COMMA_SEPARATOR = ", ";
    public static final String COLON_SEPARATOR = ": ";
    public static final String COLON = ":";
    public static final String SPACE = " ";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final List<String> INFO_SUMMARY = Arrays.asList("Version", "Planner", "Runtime");

    public static String collectNodeLabels(Node node) {
        StringBuilder sb = new StringBuilder();
        node.labels().forEach(label -> sb.append(COLON).append(NameUtil.escapeName((String)label)));
        return sb.toString();
    }

    public static String listAsString(List<String> list) {
        return list.stream().collect(Collectors.joining(COMMA_SEPARATOR, "[", "]"));
    }

    public static String mapAsStringWithEmpty(Map<String, Object> map) {
        return map.isEmpty() ? "" : OutputFormatter.mapAsString(map);
    }

    public static String mapAsString(Map<String, Object> map) {
        return map.entrySet().stream().map(e -> NameUtil.escapeName((String)((String)e.getKey())) + COLON_SEPARATOR + String.valueOf(e.getValue())).collect(Collectors.joining(COMMA_SEPARATOR, "{", "}"));
    }

    public static String joinWithSpace(List<String> strings) {
        return strings.stream().filter(OutputFormatter::isNotBlank).collect(Collectors.joining(SPACE));
    }

    public static String joinNonBlanks(String delim, List<String> strings) {
        return strings.stream().filter(OutputFormatter::isNotBlank).collect(Collectors.joining(delim));
    }

    public static boolean isNotBlank(String string) {
        return string != null && !string.trim().isEmpty();
    }

    public static char[] repeat(char c, int times) {
        char[] chars = new char[times];
        Arrays.fill(chars, c);
        return chars;
    }

    public static String repeat(String c, int times) {
        StringBuilder sb = new StringBuilder(times * c.length());
        for (int i = 0; i < times; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static Map<String, Value> info(ResultSummary summary) {
        LinkedHashMap<String, Value> result = new LinkedHashMap<String, Value>();
        if (!summary.hasPlan()) {
            return result;
        }
        Plan plan = summary.plan();
        result.put("Plan", Values.value((String)(summary.hasProfile() ? "PROFILE" : "EXPLAIN")));
        result.put("Statement", Values.value((String)(summary.queryType() != null ? summary.queryType().name() : "")));
        Map arguments = plan.arguments();
        Value emptyString = Values.value((String)"");
        Value questionMark = Values.value((String)"?");
        for (String key : INFO_SUMMARY) {
            Value value = arguments.getOrDefault(key, arguments.getOrDefault(key.toLowerCase(Locale.ROOT), emptyString));
            result.put(key, value);
        }
        result.put("Time", Values.value((long)(summary.resultAvailableAfter(TimeUnit.MILLISECONDS) + summary.resultConsumedAfter(TimeUnit.MILLISECONDS))));
        if (summary.hasProfile()) {
            result.put("DbHits", Values.value((long)OutputFormatter.collectHits(summary.profile())));
        }
        if (summary.hasProfile()) {
            result.put("Rows", Values.value((long)summary.profile().records()));
        }
        if (summary.hasProfile()) {
            result.put("Memory (Bytes)", arguments.getOrDefault("GlobalMemory", questionMark));
        }
        return result;
    }

    public static long collectHits(ProfiledPlan operator) {
        long hits = operator.dbHits();
        hits = operator.children().stream().map(OutputFormatter::collectHits).reduce(hits, Long::sum);
        return hits;
    }

    public int formatAndCount(BoltResult var1, LinePrinter var2);

    default public String formatValue(Value value) {
        if (value == null) {
            return "";
        }
        TypeRepresentation type = (TypeRepresentation)value.type();
        switch (type.constructor()) {
            case LIST: {
                return OutputFormatter.listAsString(value.asList(this::formatValue));
            }
            case MAP: {
                return OutputFormatter.mapAsString(value.asMap(this::formatValue));
            }
            case NODE: {
                return this.nodeAsString(value.asNode());
            }
            case RELATIONSHIP: {
                return this.relationshipAsString(value.asRelationship());
            }
            case PATH: {
                return this.pathAsString(value.asPath());
            }
            case POINT: {
                return this.pointAsString(value.asPoint());
            }
            case DURATION: {
                return DurationValue.parse((CharSequence)value.toString()).prettyPrint();
            }
        }
        return value.toString();
    }

    default public String pointAsString(Point point) {
        StringBuilder stringBuilder = new StringBuilder("point({");
        stringBuilder.append("srid:").append(point.srid()).append(",");
        stringBuilder.append(" x:").append(point.x()).append(",");
        stringBuilder.append(" y:").append(point.y());
        double z = point.z();
        if (!Double.isNaN(z)) {
            stringBuilder.append(", z:").append(z);
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    default public String pathAsString(Path path) {
        ArrayList<Object> list = new ArrayList<Object>(path.length());
        Node lastTraversed = path.start();
        if (lastTraversed != null) {
            list.add(this.nodeAsString(lastTraversed));
            for (Path.Segment segment : path) {
                Relationship relationship = segment.relationship();
                if (relationship.startNodeId() == lastTraversed.id()) {
                    list.add("-" + this.relationshipAsString(relationship) + "->");
                } else {
                    list.add("<-" + this.relationshipAsString(relationship) + "-");
                }
                list.add(this.nodeAsString(segment.end()));
                lastTraversed = segment.end();
            }
        }
        return String.join((CharSequence)"", list);
    }

    default public String relationshipAsString(Relationship relationship) {
        ArrayList<String> relationshipAsString = new ArrayList<String>();
        relationshipAsString.add(COLON + NameUtil.escapeName((String)relationship.type()));
        relationshipAsString.add(OutputFormatter.mapAsStringWithEmpty(relationship.asMap(this::formatValue)));
        return "[" + OutputFormatter.joinWithSpace(relationshipAsString) + "]";
    }

    default public String nodeAsString(Node node) {
        ArrayList<String> nodeAsString = new ArrayList<String>();
        nodeAsString.add(OutputFormatter.collectNodeLabels(node));
        nodeAsString.add(OutputFormatter.mapAsStringWithEmpty(node.asMap(this::formatValue)));
        return "(" + OutputFormatter.joinWithSpace(nodeAsString) + ")";
    }

    default public String formatPlan(ResultSummary summary) {
        return "";
    }

    default public String formatInfo(ResultSummary summary) {
        return "";
    }

    default public String formatFooter(BoltResult result, int numberOfRows) {
        return "";
    }

    default public String formatNotifications(ResultSummary summary) {
        return "";
    }

    public Set<Capabilities> capabilities();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Capabilities {
        INFO,
        PLAN,
        RESULT,
        FOOTER,
        STATISTICS,
        NOTIFICATIONS;

    }
}

