/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Comparator;
import java.util.List;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Help
implements Command {
    public static final String CYPHER_MANUAL_LINK = "https://neo4j.com/docs/cypher-manual/current/";
    private final Printer printer;
    private final CommandHelper.CommandFactoryHelper commandHelper;

    public Help(Printer shell, CommandHelper.CommandFactoryHelper commandHelper) {
        this.printer = shell;
        this.commandHelper = commandHelper;
    }

    @Override
    public void execute(List<String> args) throws CommandException {
        this.requireArgumentCount(args, 0, 1);
        if (args.isEmpty()) {
            this.printGeneralHelp();
        } else {
            this.printHelpFor(args.get(0));
        }
    }

    private void printHelpFor(String name) throws CommandException {
        Command.Factory cmd = this.commandHelper.factoryByName(name);
        if (cmd == null && !name.startsWith(":")) {
            cmd = this.commandHelper.factoryByName(":" + name);
        }
        if (cmd == null) {
            throw new CommandException(AnsiFormattedText.from("No such command: ").bold(name));
        }
        this.printer.printOut(AnsiFormattedText.from("\nusage: ").bold(cmd.metadata().name()).append(" ").append(cmd.metadata().usage()).append("\n\n").append(cmd.metadata().help()).append("\n").resetAndRender());
    }

    private void printGeneralHelp() {
        this.printer.printOut("\nAvailable commands:");
        List<Command.Metadata> allCommands = this.commandHelper.factories().stream().map(Command.Factory::metadata).sorted(Comparator.comparing(Command.Metadata::name)).toList();
        int leftColWidth = Help.longestCmdLength(allCommands);
        allCommands.forEach(cmd -> this.printer.printOut(AnsiFormattedText.from("  ").bold(String.format("%-" + leftColWidth + "s", cmd.name())).append(" " + cmd.description()).resetAndRender()));
        this.printer.printOut("\nFor help on a specific command type:");
        this.printer.printOut(AnsiFormattedText.from("    ").append(this.metadata().name()).bold(" command").append("\n").resetAndRender());
        this.printer.printOut("Keyboard shortcuts:");
        this.printer.printOut("    Up and down arrows to access statement history.");
        this.printer.printOut("    Tab for autocompletion of commands, hit twice to select suggestion from list using arrow keys.");
        this.printer.printOut("\nFor help on cypher please visit:");
        this.printer.printOut(AnsiFormattedText.from("    ").append(CYPHER_MANUAL_LINK).append("\n").resetAndRender());
    }

    private static int longestCmdLength(List<Command.Metadata> allCommands) {
        return allCommands.stream().mapToInt(m -> m.name().length()).max().orElse(0);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "Show the list of available commands or help for a specific command.";
            return new Command.Metadata(":help", "Show this help message", "[command]", help, List.of(":man"));
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Help(args.printer(), new CommandHelper.CommandFactoryHelper());
        }
    }
}

